package ch.sahits.game.graphic.display.dialog.util;

import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;

/**
 * This interfaces defines methods that are accessed by the Transfer actions
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 11, 2011
 *
 */
public interface ITransferableJFX {

	/**
	 * Retrieve the proxy object to access the city and the player
	 * @return
	 */
	ICityPlayerProxyJFX getCityPlayerProxy();
	/**
	 * Retrieve the dialog type of this transfer
	 * @return transfer dialog type
	 */
	EDialogType getDialogType();
	/**
	 * Retrieve the amount that should be transferred.
	 * @param availableAmountCity
	 * @return
	 */
	int getAmount(int availableAmountCity);
	/**
	 * Retreive the amount category that is movable
	 * @return
	 */
	ETransferAmount getMovableAmount();

}
