package ch.sahits.game.graphic.display.gameplay.internal;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import com.google.common.eventbus.AsyncEventBus;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 13, 2013
 */
@Component
public class MarketScenePolygonInitializer extends ScenePolygonInitialzer {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    public MarketScenePolygonInitializer() {
        super("marketPlaceScene");
    }

    @Override
    protected EventHandler<MouseEvent> createEventHandler(String name) {
        switch (name) {
            case "MarketBooth": {
                return new EventHandler<MouseEvent>() {

                    @Override
                    public void handle(MouseEvent arg0) {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_MARKET_BOOTH);
                        clientEventBus.post(new NoticeBoardUpdate(proxy));
                        clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                    }
                };
            }
            case "Floor" : {
                return new EventHandler<MouseEvent>() {

                    @Override
                    public void handle(MouseEvent arg0) {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_PORT);
                        clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                    }
                };
            }
            case "CityHall" : {
                return new EventHandler<MouseEvent>() {

                    @Override
                    public void handle(MouseEvent arg0) {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_CITY_HALL);
                        clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                    }
                };

            }
            default:
                throw new IllegalStateException("Unhandled polygon action: "+name);
        }

    }
}
