package ch.sahits.game.graphic.display.model;

import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

/**
 * State information of the player, the city and the ships.
 * This instance is tied to the ClientViewState.
 */
public class CityPlayerProxyJFX implements ICityPlayerProxyJFX {
	private final ICity city;
	private final IPlayer player;
	/** List holding all ships currently present in the city */
	private ObservableList<IShip> shipList = FXCollections.observableArrayList();
	/** List holding all ships owned by the player currently present in the city */
	private ObservableList<IShip> playerShips = FXCollections.observableArrayList();
	/** Reference the active ship of the player */
	private IShip activeShip=null;
	/**
	/**
	 * Constructor initializing the city and the player with one ship in port.
	 * @param city
	 * @param player
	 * @param activeShip
	 */
	public CityPlayerProxyJFX(ICity city, IPlayer player, IShip activeShip) {
        this.city = city;
        this.player = player;
		this.activeShip = activeShip;
		shipList.add(activeShip);
		playerShips.add(activeShip);
	}
	/* (non-Javadoc)
	 * @see ch.sahits.game.graphic.display.model.ICityPlayerProxy#getActiveShip()
	 */
	@Override
	public IShip getActiveShip() {
		return activeShip;
	}
	/**
	 * Activate a ship. If the ship is not one of the players or not in port or not available
	 * an {@link IllegalArgumentException} will be thrown
	 * @param ship
	 * @throws IllegalArgumentException if the ship cannot be activated due to its non existence
	 */
	public void activateShip(IShip ship){
		for (IShip s : playerShips) {
			if (s.equals(ship) && s.isAvailable()){
				activeShip=s;
				break; // there can only be one
			}
		}
		throw new IllegalArgumentException("The ship "+ship+" of the player is not in port");
	}
	/* (non-Javadoc)
	 * @see ch.sahits.game.graphic.display.model.ICityPlayerProxy#getPlayersShips()
	 */
	@Override
	public ObservableList<IShip> getPlayersShips(){
		return playerShips;
	}
	/**
	 * A ship arrives in the city
	 * @param ship
	 */
	public void arrive(IShip ship){
		shipList.add(ship);
		if (player.getFleet().contains(ship)){
			playerShips.add(ship);
			if (playerShips.size()==1){
				activeShip=ship;
			}
		}
	}
	/**
	 * Ship leave the city
	 * @param ship
	 */
	public void leave(IShip ship){
		if (activeShip==ship){
			activeShip=null;
		}
		playerShips.remove(ship);
		shipList.remove(ship);
	}
	/* (non-Javadoc)
	 * @see ch.sahits.game.graphic.display.model.ICityPlayerProxy#getCity()
	 */
	@Override
	public ICity getCity() {
		return city;
	}
	/* (non-Javadoc)
	 * @see ch.sahits.game.graphic.display.model.ICityPlayerProxy#getPlayer()
	 */
	@Override
	public IPlayer getPlayer() {
		return player;
	}}
