package ch.sahits.game.graphic.display.notice;


import ch.sahits.game.graphic.image.ColorSchema;
import javafx.scene.paint.Color;

/**
 * This utility class provides the color for Strings in different states as well as other colors used
 * in the notice view.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 21, 2011
 *
 */
class ColorProvider {
	/**
	 * Provide the color of the String that represents the active selection
	 * @return
	 */
	public static Color getStringColorActive(){
		return ColorSchema.BLACK;
	}
	/**
	 * Provide the color of a String that represents an inactive selection
	 * @return
	 */
	public static Color getStringColorInactive(){
		return ColorSchema.GRAYED_OUT;
	}
	/**
	 * Provide the color of a String that is currently disabled
	 * @return
	 */
	public static Color getStringColorDisabled(){
		return ColorSchema.GRAY_DISABLED;
	}
	/**
	 * Retrieve the color by the state
	 * @param state
	 * @return
	 */
	public static Color getStringColor(EStringSelectionState state){
		switch (state) {
		case ACTIVE:
			return getStringColorActive();
		case DISABLE:
			return getStringColorDisabled();
		case INACTIVE:
			return getStringColorInactive();
		}
		return null;
	}
}
