package ch.sahits.game.graphic.display.notice;
/**
 * Enumeration of notice items that are not widely used outside this package.
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 18, 2012
 *
 */
// TODO aho Dec 6, 2013: merge with EDialogType
public enum ENoticeItem {
	/** Market booth stock and prices */
	MB_STOCK_PRICES,
	/** Market booth consumtion and production */
	MB_CONSUMPTION_PRODUCTION,
	/** Trading office balance sheet */
	TO_BALANCE,
	/** Trading office personal data */
	TO_PERSONAL,
	/** Trading office consumtion and production */
	TO_CONSUMPTION_PRODUCTION,
	/** Trading office ware houses */
	TO_WAREHOUSES,
	/** Trading office automatic trading */
	TO_OFFICE_TRADING,
	/** Trading office weapons */
	TO_WEAPONS,
	/** Ware buyer in the tavern */
	TAVERN_BUYER,
	/** Sailor hiring in the tavern */
	TAVERN_SAILORS,
	/** Weapons dealer in the tavern */
	TAVERN_WEAPONS_DEALER,
	/** Informant first dialog in the tavern */
	TAVERN_INFORMANT_1,
	/** Informant second dialog in the tavern */
	TAVERN_INFORMANT_2,
	/** Captain sitting in the tavern */
	TAVERN_CAPTAIN,
	/** Pirate sitting in the tavern. */
	TAVERN_PIRATE,
	/** Traveler sitting in the tavern. */
	TAVERN_TRAVELER,
	/** Enter side room in tavern */
    @Deprecated
	TAVERN_SIDE_ROOM,
    /** Courier */
    TAVERN_COURIER,
    /** Remote trading */
    TAVERN_TRANSPORT_TRADER,
    /** Escorte */
    TAVERN_ESCORTE,
    /** Fugative */
    TAVERN_FUGATIVE,
    /** Patrol */
    TAVERN_PATROL,
    /** Burglar */
    TAVERN_BURGLAR,
    /** Concurrent */
    TAVERN_CONCURRENT,
    /** Owner of a map with a pirate nest */
    TAVERN_PIRATE_HUNTER,
    /** Warehouse tenant */
    TAVERN_WAREHOUSE_TENANT,
    /** Smuggler */
    TAVERN_SMUGGLER,
    /** Owner of a treasuremap part */
    TAVERN_TREASUREMAP_OWNER,
	/** Local trader selling wares from the city */
	TAVERN_TRADER,
	/** Build a new ship */
	SHIPYARD_CONSTRUCTION,
	/** Repair a ship */
	SHIPYARD_REPAIR,
	/** Display the construction list */
	SHIPYARD_CONSTRUCTION_LIST,
	/** Display the repair list */
	SHIPYARD_REPAIR_LIST,
	/** Upgrade a ship. */
	SHIPYARD_UPGRADE,
	/** Rename a ship. */
	SHIPYARD_RENAME,
	/** Load wares from the city onto the ship. */
	PORT_CITY_TO_SHIP,
	/** Load wares from the warehouse onto the ship. */
	PORT_STORAGE_TO_SHIP,
	/** Move wares from the city to the warehouse */
	PORT_CITY_TO_STORAGE,
	/** Load weapons onto the ship. */
	PORT_WEAPON,
	/** Take out a loan */
	LOANER_TAKE,
	/** Give a loan */
	LOANER_GIVE,
	/** Repay a debt, also listing all debts */
	LOANER_REPAY,
	/** See all outstanding given loans */
	LOANER_LIST

}
