package ch.sahits.game.graphic.display.notice;


import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.ship.IShip;

import com.google.common.base.Optional;
/**
 * State of the shipyard.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on May 25, 2013
 *
 */
public class ShipYardMetaDataJFX extends CityNoticeMetaDataJFX {

	IShipyard shipYardState;

	public ShipYardMetaDataJFX(ICityPlayerProxyJFX proxy) {
		super(proxy);
		shipYardState = proxy.getCity().getCityState().getShipyardState();
	}
	/**
	 * Retrieve the active ship in the city. There might be no ship active in which
	 * case absent is returned.
	 * @return
	 */
	public Optional<IShip> getActiveShip() {
		return Optional.fromNullable(getCityProxy().getActiveShip());
	}
	public IShipyard getShipYardState() {
		return shipYardState;
	}


}
