package ch.sahits.game.graphic.display.notice;

import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;

/**
 * Meta data for the tavern notice board.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Feb 2, 2013
 *
 */
public class TavernNoticeMetaDataJFX extends CityNoticeMetaDataJFX {
	/** Tavern state of the city */
	TavernState tavernState;

	public TavernNoticeMetaDataJFX(ICityPlayerProxyJFX proxy) {
		super(proxy);
		ICity city = proxy.getCity();
		tavernState = city.getCityState().getTavernState();
	}

}
