package ch.sahits.game.graphic.display.scene;

import ch.sahits.game.graphic.display.SceneChangeable;
import ch.sahits.game.graphic.display.util.GameOptionsService;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.javafx.OpenPatricianScene;
import ch.sahits.game.javafx.control.OpenPatricianSlider;
import ch.sahits.game.javafx.control.OpenPatricianSpinner;
import ch.sahits.game.javafx.control.OpenPatricianStoneButton;
import ch.sahits.game.javafx.control.OpenPatricianWoodenTextInput;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.EGameSpeed;
import ch.sahits.game.openpatrician.model.GameFactory;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import ch.sahits.game.util.UIFactory;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;

/**
 * Options that can be accessed from within the game.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 27, 2014
 */
@Prototype
public class InGameOptionsScene extends OpenPatricianScene {
    private final Logger logger = Logger.getLogger(getClass());
    @Autowired
    private UIFactory uiFactory;
    @Autowired
    private GameFactory gameFactory;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private GameOptionsService gameOptions;
    @Autowired
    private Date date;
    @Autowired
    private IFontLoader fontLoader;
    private IGame game;
    // Need to inject the font as for custom controls it is not stylable
    private Font font24;
    private SceneChangeable sceneChangeable;

    public InGameOptionsScene(double width, double heigth) {
        super(new StackPane(), width, heigth);
        getStylesheets().add(this.getClass().getResource(getStyleSheetFilename()).toExternalForm());
    }


    public SceneChangeable getSceneChangeable() {
        return sceneChangeable;
    }

    public void setSceneChangeable(SceneChangeable sceneChangeable) {
        this.sceneChangeable = sceneChangeable;
    }
    private String getStyleSheetFilename() {
        return "newGame.css";
    }
    @PostConstruct
    private void createControls() {
        game = gameFactory.getGame();
        font24 = fontLoader.createDefaultFont(24);
        StackPane root = (StackPane) getRoot();

        GridPane grid = new GridPane();
        grid.getStyleClass().add("grid");
        grid.setAlignment(Pos.CENTER);
        grid.getColumnConstraints().add(new ColumnConstraints(200)); // column 1
        grid.getColumnConstraints().add(new ColumnConstraints(300)); // column 2
        grid.getColumnConstraints().add(new ColumnConstraints(250)); // column 3
        grid.getColumnConstraints().add(new ColumnConstraints(100)); // column 4

        // Load
        Label loadLbl = new Label(messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.load", new Object[]{}, locale.getCurrentLocal()));
        grid.add(loadLbl, 0, 0);

        OpenPatricianSpinner lodableGames = new OpenPatricianSpinner(font24);
        grid.add(lodableGames, 1, 0);
        GridPane.setHalignment(lodableGames, HPos.LEFT);
        lodableGames.setOptionsMap(gameOptions.getSavegames());
        lodableGames.setMaxWidth(250);
        OpenPatricianStoneButton loadBtn = new OpenPatricianStoneButton(messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.load", new Object[]{}, locale.getCurrentLocal()), font24);
        grid.add(loadBtn, 3, 0);
        GridPane.setHalignment(loadBtn, HPos.LEFT);

        // Save
        Label saveLbl = new Label(messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.save", new Object[]{}, locale.getCurrentLocal()));
        grid.add(saveLbl, 0, 1);

        OpenPatricianSpinner saveableGames = new OpenPatricianSpinner(font24);
        grid.add(saveableGames, 1, 1);
        GridPane.setHalignment(saveableGames, HPos.LEFT);
        saveableGames.setOptionsMap(gameOptions.getSavegames());
        saveableGames.setMaxWidth(250);

        OpenPatricianWoodenTextInput newSaveGame = new OpenPatricianWoodenTextInput(font24);
        newSaveGame.setSize(25);
        grid.add(newSaveGame, 2, 1);

        OpenPatricianStoneButton saveBtn = new OpenPatricianStoneButton(messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.save", new Object[]{}, locale.getCurrentLocal()), font24);
        grid.add(saveBtn, 3, 1);
        GridPane.setHalignment(saveBtn, HPos.LEFT);

        // Speed
        Label gameSpeedLbl = new Label(messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.gameSpeed", new Object[]{}, locale.getCurrentLocal()));
        grid.add(gameSpeedLbl, 0, 2);

        final OpenPatricianSlider speed = new OpenPatricianSlider(font24, 200);
        speed.setValues(gameOptions.getGameSpeedList());
        int index = 0;
        final EGameSpeed currentSpeed = game.getGameSpeed();
        for (int i = 0; i < EGameSpeed.values().length; i++) {
            if (currentSpeed.equals(EGameSpeed.values()[i])) {
                index = i;
                break;
            }
        }
        speed.selectedIndexProperty().setValue(index);

        grid.add(speed, 1, 2);
        GridPane.setHalignment(speed, HPos.LEFT);

        // Quit
        OpenPatricianStoneButton quit = new OpenPatricianStoneButton(messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.quit", new Object[]{}, locale.getCurrentLocal()), font24);
        quit.setOnAction(new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent mouseEvent) {
                mouseEvent.consume();
                Platform.exit();
                System.exit(0);
            }
        });
        grid.add(quit, 0, 6);
        GridPane.setHalignment(quit, HPos.LEFT);
        // Back
        OpenPatricianStoneButton back = new OpenPatricianStoneButton(messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.back", new Object[]{}, locale.getCurrentLocal()), font24);
        grid.add(back, 3, 6);
        GridPane.setHalignment(back, HPos.RIGHT);
        back.setOnAction(new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent mouseEvent) {
                EGameSpeed gameSpeed = EGameSpeed.values()[speed.getSelectedIndex()];
                if (gameSpeed != currentSpeed) {
                    game.setGameSpeed(gameSpeed);
                }
                MainGameScene mainGame = uiFactory.getMainGameScene(getWidth(), getHeight()); // This should be cached already
                getSceneChangeable().changeScene(mainGame);

            }
        });

        root.getChildren().add(grid);
    }


}
