package ch.sahits.game.graphic.display.util;

import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.util.GamePropertyUtility;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Helper service for common option tasks.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 27, 2014
 */
@LazySingleton
public class GameOptionsService {

    private static final String SAVEGAME_DIR = GamePropertyUtility.APP_CONF_DIR+ File.separatorChar+"savegames";
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    private File savegameDir;
    @PostConstruct
    private void init() {
        File userHome = new File(System.getProperty("user.home"));
        savegameDir = new File(userHome, SAVEGAME_DIR);
        if (!savegameDir.exists()) {
            savegameDir.mkdir();
        }
    }
    /**
     * Compile a list of game speeds
     * @return
     */
    public List<String> getGameSpeedList() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.break", new Object[]{}, locale.getCurrentLocal())); // TODO utilize EGameSpeed
        l.add(messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.slow", new Object[]{}, locale.getCurrentLocal()));
        l.add(messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.normal", new Object[]{}, locale.getCurrentLocal()));
        l.add(messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.fast", new Object[]{}, locale.getCurrentLocal()));
        return l;
    }

    /**
     * Retrieve the list of savegames.
     * @return
     */
    public Map<String, String> getSavegames() {
        FilenameFilter filter = new FilenameFilter() {
            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".savegame");
            }
        };
        String[] savegames = savegameDir.list(filter);
        Map<String, String> map = new HashMap<>();
        for (String savegame : savegames) {
            map.put(savegame, savegame);
        }

        return map;
    }

}
