package ch.sahits.game.graphic.event.task;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.Random;

/**
* @author Andi Hotz, (c) Sahits GmbH, 2014
*         Created on Feb 23, 2014
*/
@Prototype
class BreakInAction extends TimedTask implements IBreakInAction {
    @Autowired
    private Date date;
    @Autowired
    private Random rnd;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    private final IPlayer opponent;
    public BreakInAction(IPlayer opponent) {
        super();
        this.opponent = opponent;
    }
    @PostConstruct
    private void initializ() {
        setExecutionTime(date.getCurrentDate().plusDays(5));
    }
    @Override
    public void run() {
        int bounty = (int)(Math.abs(opponent.getCash()/2000*rnd.nextDouble()));
        opponent.updateCash(-bounty);
        String s = messageSource.getMessage("ch.sahits.game.graphic.event.task.BreakInAction.message1", new Object[]{bounty, opponent.getLastName()}, locale.getCurrentLocal());
        DisplayMessage msg = new DisplayMessage(s, messageSource.getMessage("ch.sahits.game.graphic.event.task.BreakInAction.message2", new Object[]{}, locale.getCurrentLocal()));
        clientEventBus.post(msg);
    }

}
