package ch.sahits.game.graphic.event.task;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import java.util.List;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 23, 2014
 */
@Prototype
class BuyWares extends TimedTask {

    private final IPlayer player;
    private final ICity city;
    private final AmountablePrice<IWare> amountable;
    private final IWare ware;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;

    public BuyWares(ICityPlayerProxyJFX cityPlayerProxy, IBuyer buyer) {
        super();
        setExecutionTime(buyer.getTimeFrame());
        player = cityPlayerProxy.getPlayer();
        city = cityPlayerProxy.getCity();
        amountable = buyer.getAmountablePrice();
        ware = buyer.getWare();
    }

    @Override
    public void run() {
        ITradingOffice tradingOffice = player.findTradingOffice(city);
        int amountRequired = amountable.getAmount();
        int retrieved = 0;
        if (tradingOffice != null) {
            AmountablePrice<IWare> amountable = tradingOffice.getWare(ware);
            if (amountable.getAmount()>0) {
                retrieved = tradingOffice.move(ware, -amountRequired);
                player.getCompany().updateCash(amountable.getAVGPrice() * retrieved);
            }
        }
        if (retrieved<amountRequired) {
            List<IShip> ships = player.findShips(city);
            for (IShip ship : ships) {
                AmountablePrice<IWare> amountable = ship.getWare(ware);
                if (amountable.getAmount()>0) {
                    int toRetrieve = amountRequired-retrieved;
                    retrieved += tradingOffice.move(ware, -toRetrieve);
                    player.getCompany().updateCash(amountable.getAVGPrice() * retrieved);
                    if (retrieved>=amountRequired) {
                        break;
                    }
                }

            }
        }
        if (retrieved<amountRequired) {
            DisplayMessage msg;
            if (retrieved == 0) {

                String message = messageSource.getMessage("ch.sahits.game.graphic.event.task.BuyWares.message1", new Object[]{translator.getLocalDisplayName((EWare) ware), city.getName()}, locale.getCurrentLocal());
                msg = new DisplayMessage(message);
            } else {

                String message = messageSource.getMessage("ch.sahits.game.graphic.event.task.BuyWares.message2", new Object[]{retrieved, translator.getLocalDisplayName((EWare) ware), amountable.getAmount(), city.getName()}, locale.getCurrentLocal());
                msg = new DisplayMessage(message);
            }
            clientEventBus.post(msg);
        }

    }}
