package ch.sahits.game.graphic.event.task;

import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

/**
 * Factory for the tasks in this package.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 23, 2014
 */
@Service
public class ClientTaskFactory {
    @Autowired
    private ApplicationContext context;

    /**
     * Retrieve the oponents order.
     * @param opponent player
     * @param client who gives the order
     * @param player the order executor
     * @param premium on successful execution
     * @return
     */
    public OpponentsOrder getOpponentsOrder(IPlayer opponent,
                                            IPlayer client, IPlayer player, int premium) {
        Object[] args = new Object[]{opponent, client, player, premium};
        return (OpponentsOrder)  context.getBean("opponentsOrder", args);
    }
    /**
     * Retrieve the concurrent reconsiliation timer task.
     * @return
     */
    public ConcurrentReconciliation getConcurrentReconciliation() {
        return  context.getBean(ConcurrentReconciliation.class);
    }



    /**
     * Retrieve the timed task for buying wares.
     * @param cityPlayerProxy proxy instance
     * @param buyer client
     * @return
     */
    public BuyWares getBuyWares(ICityPlayerProxyJFX cityPlayerProxy, IBuyer buyer) {
        Object[] args = new Object[]{cityPlayerProxy, buyer};
        return (BuyWares)  context.getBean("buyWares", args);
    }

    /**
     * Retrieve the delayed caught timed task.
     * @param player that is caught
     * @return
     */
    public IDelayedCaughtAction getDelayedCaughtAction(IPlayer player) {
        Object[] args = new Object[]{player};
        return (DelayedCaughtAction)  context.getBean("delayedCaughtAction", args);
    }

    /**
     * Retrieve the task for breaking in into an opponents office.
     * @param opponent .
     * @return
     */
    public IBreakInAction getBreakInAction(IPlayer opponent) {
        Object[] args = new Object[]{opponent};
        return (BreakInAction)  context.getBean("breakInAction", args);
    }

    /**
     * Retrieve the postponed display message task.
     * @param executionTime when the message should pop up
     * @param message .
     * @return
     */
    public PostponedDisplayMessage getPostponedDisplayMessage(DateTime executionTime, String message) {
        Object[] args = new Object[]{executionTime, message};
        return (PostponedDisplayMessage)  context.getBean("postponedDisplayMessage", args);
    }
}
