package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.graphic.display.dialog.util.EDialogType;
import ch.sahits.game.graphic.display.gameplay.internal.EScene;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.display.notice.ENoticeItem;
import com.google.common.base.Preconditions;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.stereotype.Component;

/**
 * Event handler for the city hall scene.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jan 03, 2015
 */
@Component
public class CityHallSceneEventHandler implements ISceneEventHandler {
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty<>(this, "currentScene", EScene.PORT);
    private IDialogContoller dialogContoller; // this instance exists not at startup
    @Override
    public ObjectProperty<EScene> currentSceneProperty() {
        return currentScene;
    }

    @Override
    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    @Override
    public void handleEvent(Object eventNotice) {
        Preconditions.checkNotNull(dialogContoller, "Dialog controller must be initialized first");
        if (eventNotice == EViewChangeEvent.CLOSE_DIALOG) {
            dialogContoller.closeDialog();
        }
        if (eventNotice instanceof ViewChangeCityPlayerProxyJFX) {
            ViewChangeCityPlayerProxyJFX cityProxy = (ViewChangeCityPlayerProxyJFX) eventNotice;
            // Scene change market place
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_MARKET) {
                currentScene.set(EScene.MARKET);
                dialogContoller.changeScene();
            }

        }
        if (eventNotice instanceof ENoticeItem) {
            EDialogType dialogType;
            switch ((ENoticeItem)eventNotice) {
                default:
                    throw new RuntimeException("Not yet implemented eventNotice: "+eventNotice);
            }
            //dialogContoller.replaceDialog(dialogType);
        }
    }
}
