package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.dialog.util.EDialogType;
import ch.sahits.game.graphic.display.gameplay.internal.EScene;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.display.notice.ENoticeItem;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/**
 * Event handler for the loaner scene.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jan 03, 2015
 */
@Component
public class LoanerSceneEventHandler  implements ISceneEventHandler {
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty<>(this, "currentScene", EScene.PORT);
    private IDialogContoller dialogContoller; // this instance exists not at startup
    @Override
    public ObjectProperty<EScene> currentSceneProperty() {
        return currentScene;
    }

    @Override
    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    @Override
    public void handleEvent(Object eventNotice) {
        Preconditions.checkNotNull(dialogContoller, "Dialog controller must be initialized first");
        if (eventNotice == EViewChangeEvent.CLOSE_DIALOG) {
            dialogContoller.closeDialog();
        }
        if (eventNotice instanceof ViewChangeCityPlayerProxyJFX) {
            ViewChangeCityPlayerProxyJFX cityProxy = (ViewChangeCityPlayerProxyJFX) eventNotice;
            // Scene change market place
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_PORT) {
                clientEventBus.post(new NoticeBoardClose());
                currentScene.set(EScene.PORT);
                dialogContoller.changeScene();
            }

        }
        if (eventNotice instanceof ENoticeItem) {
            EDialogType dialogType;
            switch ((ENoticeItem)eventNotice) {
                case LOANER_TAKE:
                    dialogType = EDialogType.LOANER_TAKE;
                    break;
                case LOANER_GIVE:
                    dialogType = EDialogType.LOANER_GIVE;
                    break;
                case LOANER_REPAY:
                    dialogType = EDialogType.LOANER_REPAY;
                    break;
                case LOANER_LIST:
                    dialogType = EDialogType.LOANER_LIST;
                    break;
                default:
                    throw new RuntimeException("Not yet implemented eventNotice: "+eventNotice);
            }
            dialogContoller.replaceDialog(dialogType);
        }
    }
}
