package ch.sahits.game.openpatrician.spring;

import ch.sahits.game.graphic.display.notice.NoticeBoardFactory;
import ch.sahits.game.graphic.display.notice.OpenPatricianNoticeBoard;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.javafx.control.GameStatus;
import ch.sahits.game.javafx.control.MainMenu;
import ch.sahits.game.javafx.control.MiniMap;
import ch.sahits.game.javafx.control.SubMenu;
import ch.sahits.game.javafx.control.ViewStatus;
import ch.sahits.game.javafx.service.MapSegmentImageFactory;
import ch.sahits.game.openpatrician.aspect.DialogAspect;
import org.springframework.beans.factory.config.CustomScopeConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;

import java.util.Map;

import static com.google.common.collect.Maps.newHashMap;

/**
 * This is the default Spring configuration
 * that is used when the application is neither
 * started in server nor client mode.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Nov 29, 2014
 */
@Configuration
@Import({ClientServerInterfaceStandaloneConfiguration.class, ServerConfiguration.class, UICommonConfiguration.class})
@ComponentScan(basePackages = {"ch.sahits.game.event.handler"})
public class StandaloneConfiguration {

    @Bean
    public static DialogScope  dialogScope() {
        return new DialogScope();
    }
    @Bean
    public DialogAspect dialogScopeAspect() {
        return new DialogAspect();
    }
    @Bean
    public static CustomScopeConfigurer customScopeConfigurer() {
        CustomScopeConfigurer bean = new CustomScopeConfigurer();
        Map<String, Object> scopeMap = newHashMap();
        scopeMap.put("dialog", dialogScope());
        bean.setScopes(scopeMap);
        return bean;
    }
    @Bean
    @Lazy
    public NoticeBoardFactory noticeBoardFactory() {
        return new NoticeBoardFactory();
    }
    @Bean
    @Lazy
    public MiniMap miniMap() {
        return new MiniMap();
    }
    @Bean
    @Lazy
    public MainMenu mainMenu() {
        return new MainMenu();
    }
    @Bean
    @Lazy
    public SubMenu subMenu() {
        return new SubMenu();
    }
    @Bean
    @Lazy
    public OpenPatricianNoticeBoard noticeBoard() {
        OpenPatricianNoticeBoard bean = new OpenPatricianNoticeBoard();
        bean.setNoticeBoardFactory(noticeBoardFactory());
        return bean;
    }
    @Bean
    @Lazy
    public ViewStatus viewStatus() {
        return new ViewStatus();
    }
    @Bean
    @Lazy
    public GameStatus gameStatus() {
        return new GameStatus();
    }
    @Bean
    @Scope("prototype")
    public MainGameView mainGameView(double width, double height) {
        return new MainGameView(width, height);
    }
    @Bean
    public MapSegmentImageFactory mapSegmentImageFactory() {
        return new MapSegmentImageFactory();
    }

}
