package ch.sahits.game.openpatrician.spring;

import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.openpatrician.dialog.Dialog;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.event.SubscriptionLoggingExceptionHandler;
import ch.sahits.game.util.UIFactory;
import com.google.common.eventbus.AsyncEventBus;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Nov 29, 2014
 */
@Configuration
@Import({ImageConfiguration.class})
@ComponentScan(basePackages = {"ch.sahits.game.graphic.image",
        "ch.sahits.game.graphic.layout",
        "ch.sahits.game.graphic.display",
        "ch.sahits.game.graphic.loaders",
        "ch.sahits.game.graphic.javafx",
        "ch.sahits.game.javafx.util",
        "ch.sahits.game.event.handler.impl",
        "ch.sahits.game.graphic.event.task"})
public class UICommonConfiguration {
    @Autowired
    private IFontLoader fontLoader;

    @Bean
    public DecoratedTextFactory decoratedDialogTextFactory() {
        Font font = fontLoader.createDefaultFont(18);
        return new DecoratedTextFactory(font, 2* Dialog.FRAME_BORDER, 100, Dialog.WRAPPING_WIDTH);
    }
    @Bean
    public Jaxb2Marshaller jaxb2Marshaller() {
        Jaxb2Marshaller bean = new Jaxb2Marshaller();
        bean.setContextPath("ch.sahits.game.graphic.data");
        return bean;
    }
    @Bean
    public ThreadPoolTaskExecutor clientThreadPool() {
        ThreadPoolTaskExecutor pool = new ThreadPoolTaskExecutor();
        pool.setCorePoolSize(10);
        pool.setMaxPoolSize(30);
        pool.setQueueCapacity(15);
        return pool;
    }
    @Bean
    public SubscriptionLoggingExceptionHandler subscriptionExceptionClientHandler() {
        return new SubscriptionLoggingExceptionHandler("eventBusException");
    }

    @Bean
    public AsyncEventBus clientEventBus() {
        return new AsyncEventBus(clientThreadPool(), subscriptionExceptionClientHandler());
    }
    @Bean
    public ReloadableResourceBundleMessageSource messageSource() {
        ReloadableResourceBundleMessageSource bundle = new ReloadableResourceBundleMessageSource();
        bundle.setDefaultEncoding("UTF-8");
        bundle.setBasename("/text");
        return bundle;
    }

    @Bean
    public ReloadableResourceBundleMessageSource resourceReference() {
        ReloadableResourceBundleMessageSource bundle = new ReloadableResourceBundleMessageSource();
        bundle.setBasename("/resources");
        return bundle;
    }
    @Bean
    public UIFactory uiFactory() {
        return new UIFactory();
    }
}
