package ch.sahits.game.util;

import ch.sahits.game.graphic.display.OpenPaticianApplicationWindow;
import ch.sahits.game.graphic.display.scene.CreditsScene;
import ch.sahits.game.graphic.display.scene.HanseaticHistoryScene;
import ch.sahits.game.graphic.display.scene.InGameOptionsScene;
import ch.sahits.game.graphic.display.scene.MainGameScene;
import ch.sahits.game.graphic.display.scene.NewGameScene;
import ch.sahits.game.graphic.display.scene.StartupScene;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.graphic.image.IJavaFXControlLoader;
import ch.sahits.game.graphic.image.impl.FontLoader;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.javafx.control.GameStatus;
import ch.sahits.game.javafx.control.MainMenu;
import ch.sahits.game.javafx.control.MiniMap;
import ch.sahits.game.javafx.control.NoticeBoard;
import ch.sahits.game.javafx.control.SubMenu;
import ch.sahits.game.javafx.control.ViewStatus;
import ch.sahits.game.openpatrician.collections.NonReplacableMap;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import javafx.scene.Scene;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

import javax.annotation.PostConstruct;

/**
 * Factory class for various instances.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 01, 2014
 */
public class UIFactory {
    @Autowired
    private ApplicationContext context;
    /**
     * Scenes must be declared as prototypes as they have constructor arguments, even though they actually
     * are singletons. Therefore cache them here with the bean name.
     */
    private final NonReplacableMap<String, Scene> sceneMap = new NonReplacableMap<>();

    private IJavaFXControlLoader jfxControlLoader;
    @PostConstruct
    private void init() {
        jfxControlLoader = new JavaFXControlLoader();
    }
    /**
     * Retrieve the XML image loader for the main screen
     * @return
     */
    public IDataImageLoader getXMLImageLoader(){
        return (IDataImageLoader) context.getBean("mainScreenXMLImageLoader");
    }
    public MainGameScene getMainGameScene(double width, double heigth) {
        if (!sceneMap.containsKey("mainGameScene")) {
            sceneMap.put("mainGameScene", (Scene) context.getBean("mainGameScene", width, heigth, getXMLImageLoader(), jfxControlLoader));
        }
        return (MainGameScene) sceneMap.get("mainGameScene");
    }
    public StartupScene getStartupScene(double width, double heigth) {
        if (!sceneMap.containsKey("startupScene")) {
            sceneMap.put("startupScene", (StartupScene) context.getBean("startupScene", width, heigth));
        }
        return (StartupScene) sceneMap.get("startupScene");
    }
    public HanseaticHistoryScene getHanseaticHistoryScene(double width, double heigth) {
        if (!sceneMap.containsKey("hanseaticHistoryScene")) {
            sceneMap.put("hanseaticHistoryScene", (HanseaticHistoryScene) context.getBean("hanseaticHistoryScene", width, heigth));
        }
        return (HanseaticHistoryScene) sceneMap.get("hanseaticHistoryScene");
    }

    public CreditsScene getCreditsScene(double width, double heigth) {
        if (!sceneMap.containsKey("creditsScene")) {
            sceneMap.put("creditsScene", (CreditsScene) context.getBean("creditsScene", width, heigth));
        }
        return (CreditsScene) sceneMap.get("creditsScene");
    }
    public NewGameScene getNewGameScene(double width, double heigth) {
        if (!sceneMap.containsKey("newGameScene")){
            RandomNameLoader firstNameLoader = (RandomNameLoader) context.getBean("firstNameLoader");
            RandomNameLoader lastNameLoader = (RandomNameLoader) context.getBean("lastNameLoader");

            NewGameScene newGameScene = (NewGameScene) context.getBean("newGameScene", width, heigth, firstNameLoader, lastNameLoader);
            newGameScene.setSceneChangeable(OpenPaticianApplicationWindow.getApplication());
            sceneMap.put("newGameScene", newGameScene);
        }
        return (NewGameScene) sceneMap.get("newGameScene");
    }

    public InGameOptionsScene getInGameOptionsScene(double width, double heigth) {
        if (!sceneMap.containsKey("inGameOptionsScene")) {
            sceneMap.put("inGameOptionsScene", (InGameOptionsScene) context.getBean("inGameOptionsScene", width, heigth));
        }
        return (InGameOptionsScene) sceneMap.get("inGameOptionsScene");
    }
    public IJavaFXControlLoader getJavaFXControlLoader() {
        return jfxControlLoader;
    }







    private class JavaFXControlLoader implements IJavaFXControlLoader {

        @Override
        public MiniMap getMiniMap() {
            return (MiniMap) context.getBean("miniMap");
        }

        @Override
        public MainMenu getMainMenu() {
            return (MainMenu) context.getBean("mainMenu");
        }

        @Override
        public SubMenu getSubMenu() {
            return (SubMenu) context.getBean("subMenu");
        }

        @Override
        public NoticeBoard getNoticeBoard() {
            NoticeBoard noticeBoard = context.getBean(NoticeBoard.class);
            noticeBoard.setFont(getFontLoader().createDefaultFont(18));
            return noticeBoard;
        }

        @Override
        public ViewStatus getViewStatus() {
            return (ViewStatus) context.getBean("viewStatus");
        }

        @Override
        public IFontLoader getFontLoader() {
            return context.getBean(FontLoader.class);
        }

        @Override
        public GameStatus getGameStatus() {
            return context.getBean(GameStatus.class);
        }
        @Override
        public MainGameView getMainGameView(double width, double heigth) {
            Object[] args = new Object[]{width, heigth};
            return (MainGameView) context.getBean("mainGameView", args);
        }

    }
}
