package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.ShipAttackEvent;
import ch.sahits.game.event.data.PatrolInternalState;
import ch.sahits.game.event.handler.IAttackListener;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 21, 2014
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class AttackListener implements IAttackListener {
    private final IShip ship;
    private final PatrolInternalState state;
    @Autowired
    @Qualifier("serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;

    public AttackListener(IShip ship, PatrolInternalState state) {
        super();
        this.ship = ship;
        this.state = state;
    }
    @PostConstruct
    private void initializeEventBus() {
        clientServerEventBus.register(this);
    }
    @PreDestroy
    public void unregisterEventBus() { clientServerEventBus.unregister(this);}

    @Subscribe
    public void handleShipAttack(ShipAttackEvent event) {
        if (event.getAttackedShip().equals(ship)) {
            state.incAttackCounter();
        }
    }
}
