package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.data.CourierPatrolStateInternal;
import ch.sahits.game.event.data.PatrolInternalState;
import ch.sahits.game.event.handler.IAttackListener;
import ch.sahits.game.graphic.display.notice.ENoticeItem;
import ch.sahits.game.javafx.control.DisplayMessageOverlayLabel;
import ch.sahits.game.javafx.control.ScrollPaneContent;
import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.javafx.util.INoticeBoardDestinction;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.dialog.DialogTemplate;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import java.util.Iterator;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 16, 2014
 */
@Service
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class EventHandlerFactory {
    @Autowired
    private ApplicationContext context;
    @Autowired
    private TextSizingUtility sizeing;

    /**
     * Retrieve the event handler for delivering packages
     * @param city to which should be delivered
     * @param ship that delivers
     * @param deadline until the delivery has to take place
     * @return
     */
    public DeliverPackages getDeliverPackagesHandler(ICity city, IShip ship, DateTime deadline, int premium, int amount) {
        Object[] args = new Object[]{city, ship, deadline, premium,  amount};
        return (DeliverPackages)  context.getBean("deliverPackages", args);
    }

    public ShipArrivalForLoading getShipArrivalForLoadingHandler(ICity city, IPlayer player, DateTime deadline, int requiredAmount, int premium) {
        Object[] args = new Object[]{city, player, deadline, requiredAmount, premium};
        return (ShipArrivalForLoading)  context.getBean("shipArrivalForLoading", args);
    }

    /**
     * Event handler for a passenger leaving the ship in a city
     * @param ship that is left
     * @param city destination
     * @param shipsOwner
     * @param premium on succesfull delivery
     * @return
     */
    public PassengerLeavesShipOnArival getPassengerLeavingOnShipArrivalHandler(IShip ship, ICity city, IPlayer shipsOwner, int premium) {
        Object[] args = new Object[]{ship, city, shipsOwner, premium};
        return (PassengerLeavesShipOnArival)  context.getBean("passengerLeavesShipOnArival", args);
    }

    /**
     * Create the handler for unloading anonymous ware and register it with the event bus.
     * @param ship ship that has the ware loaded
     * @param city into which the ship should arrive
     * @param loadedAmount amount of anonymous ware loaded.
     * @return
     */
    public UnloadOnArival getUnloadOnArrivalHandler(IShip ship, ICity city, int loadedAmount) {
        return (UnloadOnArival) context.getBean("unloadOnArival", new Object[]{ship, city, loadedAmount});
    }

    /**
     * Retrieve the event handler for the next patrol station
     * @param ship that is on patrol
     * @param city next city
     * @param state patrol state
     * @param player
     * @param deadline until the patrol has to reach the city
     * @return
     */
    public NextCourierPatrolStation getNextCourierPatrolStationHanlder(IShip ship, ICity city, CourierPatrolStateInternal state, IPlayer player, DateTime deadline) {
        Object[] args = new Object[]{ship, city, state, player, deadline};
        return (NextCourierPatrolStation)  context.getBean("nextCourierPatrolStation", args);
    }

    /**
     * Retrieve the event handler for a new view change runnable.
     * @param selected notice item that is selected.
     * @return
     */
    public ViewChangeActionRunnable getViewChangeActionRunnable(ENoticeItem selected) {
        Object[] args = new Object[]{selected};
        return (ViewChangeActionRunnable)  context.getBean("viewChangeActionRunnable", args);
    }
    /**
     * Retrieve the event handler for a new view change runnable.
     * @param selected notice item that is selected.
     * @return
     */
    public ViewChangeActionRunnable getViewChangeActionRunnable(INoticeBoardDestinction selected) {
        Object[] args = new Object[]{selected};
        return (ViewChangeActionRunnable)  context.getBean("viewChangeActionRunnable", args);
    }
    public ViewChangeDialogTemplateRunnable getViewChangeActionRunnable(DialogTemplate template) {
        Object[] args = new Object[]{template};
        return (ViewChangeDialogTemplateRunnable)  context.getBean("viewChangeDialogTemplateRunnable", args);
    }

    /**
     * Create a runnable that does nothing.
     * @return
     */
    public Runnable createNOPRunnable() {
        return new Runnable() {
            @Override
            public void run() {

            }
        };
    }

    public EventHandler<MouseEvent> getDisplaMessageMouseEnterFocusEventHandler(ScrollPaneContent content, String message) {
        final Group viewContainer = (Group) ((StackPane)content.getScene().getRoot()).getChildren().get(1);
        return new EventHandler<MouseEvent>() {
            public void handle(javafx.scene.input.MouseEvent event) {
                DisplayMessageOverlayLabel label = new DisplayMessageOverlayLabel(message, sizeing);
                double y = event.getSceneY();
                label.setLayoutY(y);
                label.setLayoutX(350);	// todo: andi 3/8/15: Use some kind of constant. Also consider that the width of the control board may be scalable at one time in the future
                viewContainer.getChildren().add(label);  // Add it to the scene and not the scroll pane and adjust the location
            }
        };
    }
    public EventHandler<MouseEvent> getDisplayMessageMouseExitFocusEventHandler(ScrollPaneContent content){
        final Group viewContainer = (Group) ((StackPane)content.getScene().getRoot()).getChildren().get(1);
        return new EventHandler<MouseEvent>() {
             @Override
             public void handle(MouseEvent event) {
                 for (Iterator<Node> iterator = viewContainer.getChildren().iterator(); iterator.hasNext(); ) {
                     Node node =  iterator.next();
                     if (node instanceof DisplayMessageOverlayLabel) {
                         iterator.remove();
                         break;
                     }
                 }
             }
         };
    }

    /**
     * Retrieve the event handler for talking to a sideroom person
     * @param showingPerson person to talk to
     * @param tavernState state of the tavern
     * @param player player instance
     * @return
     */
    public TavernDialogTalkToSideroomPersonAction getTavernTalkToSidreroomPersonAction(IPerson showingPerson,
                                                                                       TavernState tavernState, IPlayer player) {
        Object[] args = new Object[]{showingPerson, tavernState, player};
        return (TavernDialogTalkToSideroomPersonAction)  context.getBean("tavernDialogTalkToSideroomPersonAction", args);
    }

    /**
     * Retrieve the event handler for changing the dialog in the tavern.
     * @param showingPerson person to talk to
     * @param tavernState state of the tavern
     * @param currentPlayer player instance
     * @return
     */
    public TavernDialogChangeAction getTavernChangeActionHandler(IPerson showingPerson,
                                                                 TavernState tavernState,
                                                                 IPlayer currentPlayer) {
        Object[] args = new Object[]{showingPerson, tavernState, currentPlayer};
        return (TavernDialogChangeAction)  context.getBean("tavernDialogChangeAction", args);
    }

    /**
     * Get the attack listener for a standard patrol.
     * @param ship doing the patrol
     * @param state patrol state
     * @return
     */
    public IAttackListener getAttackListener(IShip ship, PatrolInternalState state) {
        Object[] args = new Object[]{ship, state};
        return (AttackListener)  context.getBean("attackListener", args);
    }

    /**
     * Retrieve the next patrol station event listener
     * @param ship doing the patrrol
     * @param city next city
     * @param state current state
     * @param player .
     * @param deadline until when the city has to be reached
     * @param atackListener listener for attacks
     * @return
     */
    public NextPatrolStation getNextPatrolStateion(IShip ship, ICity city, PatrolInternalState state, IPlayer player, DateTime deadline, IAttackListener atackListener) {
        Object[] args = new Object[]{ship, city, state, player, deadline, atackListener};
        return (NextPatrolStation)  context.getBean("nextPatrolStation", args);
    }


    /**
     * Retrieve the concurrent ship order
     * @param opponent player
     * @param player the order executor
     * @param offerdTime time to execute the task
     * @param premium on successful execution
     * @param reconciliation timer task for the reconcialiation
     * @return
     */
    public SinkConcurrentsShipOrder getSinkConcurrentsShipOrder(IPlayer opponent,
                                                                IPlayer player, int offerdTime, int premium, TimedTask reconciliation) {
        Object[] args = new Object[]{opponent, player, offerdTime, premium, reconciliation};
        return (SinkConcurrentsShipOrder)  context.getBean("sinkConcurrentsShipOrder", args);
    }



}
