package ch.sahits.game.event.handler.impl;

import ch.sahits.game.graphic.display.notice.ENoticeItem;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IPerson;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 17, 2014
 */
@Prototype
@ClassCategory({EClassCategory.HANDLER, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
class TavernDialogTalkToSideroomPersonAction extends ViewChangeActionRunnable {
    private final IPerson showingPerson;
    private final TavernState tavernState;
    private final IPlayer player;

    private TavernDialogTalkToSideroomPersonAction(IPerson showingPerson,
                                                   TavernState tavernState, IPlayer player) {
        super(ENoticeItem.TAVERN_SIDE_ROOM);
        this.showingPerson = showingPerson;
        this.tavernState = tavernState;
        this.player = player;
    }

    @Override
    public void run() {
        tavernState.talkingToProperty().get().put(showingPerson, player);
        super.run();
    }
}
