package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.notice.ENoticeItem;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.javafx.util.INoticeBoardDestinction;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * Runnable implementation of a view change action, that can be used in a JavaFX event handler.
 * Handling the clicks on the notice for the market booth.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 17, 2014
 */
@Prototype
@ClassCategory(EClassCategory.HANDLER)
class ViewChangeActionRunnable implements Runnable {
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    /** Indicate the item that is selected */
    private final ENoticeItem selected; // fixme: andi 3/16/15: replace usages of ENoticeItem with INoticeBoardDestinction
    private final INoticeBoardDestinction distinction;


    public ViewChangeActionRunnable(ENoticeItem selected) {
        super();
        Preconditions.checkNotNull(selected, "The notice item my not be null");
        this.selected = selected;
        this.distinction = null;
    }
    public ViewChangeActionRunnable(INoticeBoardDestinction distinction) {
        super();
        Preconditions.checkNotNull(distinction, "The notice item my not be null");
        this.selected = null;
        this.distinction = distinction;
    }


    @Override
    public void run() {
        if (selected != null) {
            clientEventBus.post(new ViewChangeEvent(MainGameView.class, selected));
        } else {
            clientEventBus.post(new ViewChangeEvent(MainGameView.class, distinction));
        }
    }
}
