package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.ShipEntersPortEvent;
import ch.sahits.game.event.handler.ShipArivalInPortEventListener;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Wait for until a defined time for the arrival of a ship in a city.
 * If the time has passed this event listener unregisters itself from the queue.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Feb 20, 2013
 *
 */
public abstract class WaitTimeForShipArrival extends ShipArivalInPortEventListener {

	private final DateTime deadline;
    @Autowired
	private Date date;

	public WaitTimeForShipArrival(ICity city, IPlayer player, DateTime deadline) {
		super(city, player);
		this.deadline = deadline;
	}



	public Date getDate() {
		return date;
	}


    @Override
    public void handleShipEntersPort(ShipEntersPortEvent event) {
        if (date.getCurrentDate().isAfter(deadline)){
            clientServerEventBus.unregister(this);
        } else {
            super.handleShipEntersPort(event);
        }
    }


}
