package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.dialog.util.EDialogType;
import ch.sahits.game.javafx.control.BarrelIconView;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.binding.StringBinding;
import javafx.scene.Group;
import javafx.scene.image.ImageView;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

/**
 * Dialog for trading between the city and the ship.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 23, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class CityStorageTradeDialog extends BaseTradeDialog {
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;
	@Autowired
	private Locale locale;

	@Autowired
	private MessageSource messageSource;

	public CityStorageTradeDialog(Font font, ICityPlayerProxyJFX city) {
		super(font, city, EDialogType.CITY_TO_STORAGE);
	}


	/**
	 * Trade to the ship.
	 * @return
	 */
	@Override
	protected String getTradeToDestination() {
		return messageSource.getMessage("ch.sahits.game.graphic.display.dialog.CityStorageTradeDialog.storage", new Object[]{}, locale.getCurrentLocal());
	}
	@Override
	protected Group createSubTitle(Font font, final ICityPlayerProxyJFX city) {
		StringBinding cityPopulation = new StringBinding() {
			{
				super.bind(city.getCity().getPopulationBinding());
			}
			
			@Override
			protected String computeValue() {
				ICity actualCity = city.getCity();
				return actualCity.getName()+" "+actualCity.getPopulationBinding().asString().get();
			}
		};
		Text cityText = new Text();
		cityText.textProperty().bind(cityPopulation);
		cityText.setFont(font);
		Group g = new Group();
		g.setManaged(false);
		
		final ITradingOffice office = city.getPlayer().findTradingOffice(city.getCity());
		ImageView barrel = new BarrelIconView();
		barrel.setLayoutX(200 - 26);
		barrel.setLayoutY(-12);
		
		StringBinding storageLoad = new StringBinding() {
			
			{
				super.bind(office.storedAmountBinding(), office.capacityProperty());
			}
			
			@Override
			protected String computeValue() {
				return office.storedAmountBinding().asString().get()+" / "+office.capacityProperty().get();
			}
		};
		
		Text shipSpace = new Text();
		shipSpace.textProperty().bind(storageLoad);
		shipSpace.setFont(font);
		shipSpace.setLayoutX(200);
		
		Text shipName = new Text(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.CityStorageTradeDialog.storage", new Object[]{}, locale.getCurrentLocal()));
		shipName.setFont(font);
		shipName.setLayoutX(300);
		
		g.getChildren().addAll(cityText, barrel, shipSpace, shipName);
		return g;
	}


	@Override
	protected void executeOnCloseButtonClicked() {
        clientEventBus.post(new NoticeBoardClose());
		super.executeOnCloseButtonClicked();
	}
	
	

}
