package ch.sahits.game.graphic.display.dialog.action;

import ch.sahits.game.graphic.display.dialog.util.EDialogType;
import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.model.product.IWare;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.HashMap;

/**
 * This proxy handles the execution of the sell action based on the current
 * type of the dialog.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 18, 2011
 *
 */
@ClassCategory(EClassCategory.HANDLER)
public class SellJFXProxyAction implements Runnable {
	private static final Logger logger = LogManager.getLogger(SellJFXProxyAction.class);
	private final ITransferableJFX dialog;
	@MapType(key = EDialogType.class, value = Runnable.class)
	private final HashMap<EDialogType, Runnable> actionMap;
	

	public SellJFXProxyAction(IWare ware, ITransferableJFX dialog) {
		super();
		this.dialog = dialog;
		actionMap = new HashMap<EDialogType, Runnable>();
		actionMap.put(EDialogType.CITY_TO_SHIP, new Ship2CityJFXAction(ware, dialog));
		actionMap.put(EDialogType.CITY_TO_STORAGE, new Storage2CityJFXAction(ware,dialog));
		actionMap.put(EDialogType.STORAGE_TO_SHIP, new Storage2ShipJFXAction(ware,dialog));
	}

	/**
	 * Delegate to the run method of the action associated with the dialog type
	 */
	@Override
	public void run() {
		Runnable action = actionMap.get(dialog.getDialogType());
		if (action==null){
			logger.error("No action defined for dialog transfer type: "+dialog.getDialogType());
		} else {
			action.run();
		}
	}

}
