package ch.sahits.game.graphic.display.dialog.action;


import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.ship.IShip;

/**
 * This action handles the case of transfering wares from the ship into the storage
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 24, 2011
 *
 */
@ClassCategory(EClassCategory.HANDLER)
class Ship2StorageJFXAction implements Runnable {
	private final IWare ware;
	private final ITransferableJFX dialog;
//	private static final Logger logger = Logger.getLogger(Ship2StorageAction.class.getName());

	public Ship2StorageJFXAction(IWare ware, ITransferableJFX dialog) {
		super();
		this.ware = ware;
		this.dialog=dialog;
	}

	@Override
	public void run() {
		ICityPlayerProxyJFX city = dialog.getCityPlayerProxy();
		IShip ship = city.getActiveShip();
		int availableAmountShip = ship.getWare(ware).getAmount();
		ITradingOffice office = city.getPlayer().findTradingOffice(city.getCity());
		if (availableAmountShip>0 && office!=null){
			int amount2Move = dialog.getAmount(availableAmountShip); // This is ware specific size
			int avgPrice = ship.getWare(ware).getAVGPrice();
			int moved = ship.unload(ware, amount2Move);
			office.move(ware, moved,avgPrice);
		}

	}

}
