package ch.sahits.game.graphic.display.dialog.action;


import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import javafx.beans.property.SimpleIntegerProperty;

/**
 * This action handles the selling of wares from the storage to the city.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 24, 2011
 *
 */
@ClassCategory(EClassCategory.HANDLER)
class Storage2CityJFXAction implements Runnable {
	private final IWare ware;
	private final ITransferableJFX dialog;
//	private static final Logger logger = Logger.getLogger(Storage2CityAction.class.getName());

	public Storage2CityJFXAction(IWare ware, ITransferableJFX dialog) {
		super();
		this.ware = ware;
		this.dialog=dialog;
	}

	@Override
	public void run() {
		ICityPlayerProxyJFX city = dialog.getCityPlayerProxy();
		ITradingOffice office = city.getPlayer().findTradingOffice(city.getCity());
		if (office!=null) {
			int amountInStorage = office.getWare(ware).getAmount();
			if (amountInStorage > 0) {
				int availableAmountCity = city.getCity().getWare(ware).getAmount();
				int amount2Move = dialog.getAmount(amountInStorage);
				final int avgPrice;
				if (dialog.getMovableAmount() == ETransferAmount.MAX) {
					avgPrice = ware.getMaxValueSell();
				} else {
					avgPrice = ware.sellPrice(new SimpleIntegerProperty(availableAmountCity), new ConstantIntegerBinding(amount2Move));
				}
				city.getCity().move(ware, amount2Move,city.getPlayer()); // The price here is irrelevant
				int sold = office.move(ware, -amount2Move);
				city.getPlayer().updateCash(avgPrice * sold);
			} // end stored amount
		} // end office 
	}
	
}
