package ch.sahits.game.graphic.display.dialog.cityhall;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.image.impl.XMLImageLoader;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.engine.land.city.CityHallEngine;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Treasury;
import ch.sahits.game.openpatrician.model.city.impl.CityWall;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 09, 2015
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class CityWallBuildingDialog extends CloseButtonDialog {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private CityHallEngine cityHallEngine;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    @Qualifier("mainScreenXMLImageLoader")
    private XMLImageLoader imageLoader;
    @Autowired
    private Date date;

    private final ICityPlayerProxyJFX city;
    private IntegerProperty numberOfBricks;

    public CityWallBuildingDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        getStylesheets().add(this.getClass().getResource("/styles/base.css").toExternalForm());
        getStyleClass().add("dialog");
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.title", new Object[]{}, locale.getCurrentLocal()));
        CityWall cityWall = city.getCity().getCityState().getCityWall();
        final ICityHall cityHall = cityHallEngine.findCityHall(city.getCity());
        ICitizen mayor = cityHall.getMayor();
        boolean upgrading = cityWall.getBoughtBricks() < cityWall.getRequiredBricks();
        VBox box = textFactory.createMultiParagraphContainer();
        Object[] args = new Object[0];
        if (upgrading) {
            switch (cityWall.getExtension()) {
                case EXTENDED_ONCE: {
                    String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.notExtended", args, locale.getCurrentLocal());
                    DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
                    box.getChildren().add(text);
                    }
                    break;
                case EXTENDED_TWICE: {
                    String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.extensionOne", args, locale.getCurrentLocal());
                    DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
                    box.getChildren().add(text);
                    }
                    break;
                default:
                    throw new IllegalStateException("Unhandled extension state "+cityWall.getExtension()+" for upgrading");
           }
        } else {
            switch (cityWall.getExtension()) {
                case NOT_EXTENDED: {
                    String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.notExtended", args, locale.getCurrentLocal());
                    DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
                    box.getChildren().add(text);
                }
                break;
                case EXTENDED_ONCE: {
                    String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.extensionOne", args, locale.getCurrentLocal());
                    DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
                    box.getChildren().add(text);
                }
                break;
                case EXTENDED_TWICE: {
                    String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.extensionTwo", args, locale.getCurrentLocal());
                    DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
                    box.getChildren().add(text);
                }
                break;
            }
        }
            if (upgrading) {
                double progress = 1.0*cityWall.getRequiredBricks()/cityWall.getUsedBricks();
                args = new Object[]{progress};
                String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.upgrade", args, locale.getCurrentLocal());
                DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
                box.getChildren().add(text);
                if (mayor.equals(city.getPlayer())) {
                    args = new Object[]{cityWall.getRequiredBricks() - cityWall.getBoughtBricks()};
                    template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.missingBricks", args, locale.getCurrentLocal());
                    text = textFactory.createDecoratedText(template, new HashMap<>());
                    box.getChildren().add(text);
                    HBox buyBrickBox = new HBox();
                    template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.buyBricks", new Object[0], locale.getCurrentLocal());
                    text = textFactory.createDecoratedText(template, new HashMap<>());
                    numberOfBricks = new SimpleIntegerProperty(0);
                    Image img = imageLoader.getImage("icons/plusIcon");
                    ImageView plusIcon = new ImageView(img);
                    plusIcon.setId("plusIcon");
                    plusIcon.setOnMouseReleased((e) -> {
                        int newValue = Math.min(cityWall.getRequiredBricks(), numberOfBricks.get() + 1);
                        final int amount = city.getCity().getWare(EWare.BRICK).getAmount();
                        newValue = Math.min(newValue, amount);
                        numberOfBricks.setValue(newValue);
                    });
                    Label nbBricks = new Label();
                    nbBricks.textProperty().bind(numberOfBricks.asString());
                    img = imageLoader.getImage("icons/minusIcon");
                    ImageView minusIcon = new ImageView(img);
                    minusIcon.setId("minusIcon");
                    minusIcon.setOnMouseReleased((e) -> {
                        int newValue = Math.max(0, numberOfBricks.get() - 1);
                        newValue = Math.min(newValue, city.getCity().getWare(EWare.BRICK).getAmount());
                        numberOfBricks.setValue(newValue);
                    });
                    buyBrickBox.getChildren().addAll(text, minusIcon, nbBricks, plusIcon);
                    box.getChildren().add(buyBrickBox);
                    final OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.buy", new Object[]{}, locale.getCurrentLocal()), getFont());
                    action.setId("action");
                    action.setOnAction(e -> {
                        if (numberOfBricks.get() > 0) {
                            AmountablePrice<IWare> amount = city.getCity().getWare(EWare.BRICK);
                            // deduct from treasury

                            int price = EWare.BRICK.buyPrice(amount.amountProperty(), new IntegerBinding() {
                                {
                                    super.bind(numberOfBricks);
                                }
                                @Override
                                protected int computeValue() {
                                    return numberOfBricks.get();
                                }
                            });
                            // transfer from the city to the cityWall object
                            int moved = city.getCity().move(EWare.BRICK, -numberOfBricks.get(), mayor);
                            int totalPrice = price * -moved;
                            ((Treasury)cityHall.getTreasury()).subtractBuildingCosts(totalPrice);
                            cityWall.setBoughtBricks(cityWall.getBoughtBricks() - moved);
                        }
                        executeOnCloseButtonClicked();
                    });
                    box.getChildren().add(action);
                }
            }
        getContent().addAll(box);
    }

    /**
     * Update the notice board and close the dialog.
     */
    @Override
    protected void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_CITY_HALL_ELDERMAN);
        clientEventBus.post(new NoticeBoardUpdate(proxy));
        super.executeOnCloseButtonClicked();
    }

    private StyleableObjectProperty<Font> font;

    public Font getFont() {
        return font == null ? Font.getDefault() : font.get();
    }

    public void setFont(Font font) {
        this.font.set(font);
    }

    public StyleableObjectProperty<Font> fontProperty() {
        if (font == null) {
            font = new SimpleStyleableObjectProperty<Font>(StyleableProperties.FONT, CityWallBuildingDialog.this, "font", Font.getDefault());
        }
        return font;
    }

    private static class StyleableProperties {
        private static final CssMetaData<CityWallBuildingDialog, Font> FONT =
                new CssMetaData<CityWallBuildingDialog, Font>("-fx-font",
                        StyleConverter.getFontConverter(), Font.getDefault()) {
                    @Override
                    public boolean isSettable(CityWallBuildingDialog control) {
                        return control.font == null || !control.font.isBound();
                    }

                    @Override
                    public StyleableProperty<Font> getStyleableProperty(CityWallBuildingDialog control) {
                        return control.fontProperty();
                    }
                };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        static {
            final List<CssMetaData<? extends Styleable, ?>> styleables =
                    new ArrayList<CssMetaData<? extends Styleable, ?>>(Control.getClassCssMetaData());
            Collections.addAll(styleables,
                    FONT
            );
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

}
