package ch.sahits.game.graphic.display.dialog.loaner;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.engine.land.city.LoanerEngine;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.city.impl.LoanerState;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.HashMap;

/**
 * List all the loans a player has granted.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jan 06, 2015
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class LoanerListLoansDialog extends CloseButtonDialog {
    private final int BUTTON_X = (WIDTH - 124) / 2;
    private final int BUTTON_Y = CLOSE_BTN_Y_POS - 24;


    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private LoanerEngine loanerEngine;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private Date date;
    @Autowired
    private ClientViewState viewState;

    private LoanerState loaner;
    private final ICityPlayerProxyJFX city;
    private final Font font;

    public LoanerListLoansDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
    }
    @PostConstruct
    private void initializeDialog() {
        final ICity city1 = city.getCity();
        loaner = (LoanerState) loanerEngine.getLoaner(city1);
        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerListLoansDialog.title", new Object[]{}, locale.getCurrentLocal()));
        String header = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerListLoansDialog.subHeader", new Object[]{}, locale.getCurrentLocal());
        VBox box = new VBox(5);
        box.setLayoutX(2*FRAME_BORDER);
        box.setLayoutY(200);
        Text subHeading = new Text();
        subHeading.setText(header);
        subHeading.setFont(font);
        box.getChildren().add(subHeading);
        String cityName = city1.getName();
        for (IDebt debt : loanerEngine.findLoans(loaner, city.getPlayer())) {
            final ICitizen debitor = debt.getDebitor();
            String title = translator.getLocalDisplayName(debitor.getRank());
            int paybacksum = (int)(debt.getInterest() * debt.getAmount());
            final DateTime dueDate1 = debt.getDueDate();
            String dueDate = date.todisplayString(dueDate1.getDayOfMonth(), dueDate1.getMonthOfYear(), dueDate1.getYear());

            String s = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerListLoansDialog.outstandingLoan", new Object[]{title, debitor.getName(), debitor.getLastName(), cityName, paybacksum, dueDate}, locale.getCurrentLocal());
            DecoratedText entry = textFactory.createDecoratedText(s, new HashMap<String, Object>());
            box.getChildren().add(entry);
        }
        getContent().addAll(box);

    }
    /**
     * Update the notice board and close the dialog.
     */
    @Override
    protected void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_LOANER);
        clientEventBus.post(new NoticeBoardUpdate(proxy));
        super.executeOnCloseButtonClicked();
    }
}
