package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.HashMap;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 27, 2013
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernBuyerDialog extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private TimedUpdatableTaskList timedTaskList;
    @Autowired
    private ClientTaskFactory taskFactory;

    @Autowired
    private ModelTranslations translator;

    public TavernBuyerDialog(Font font, ICityPlayerProxyJFX city) {
        super(font, city, city.getCity().getCityState().getTavernState().getBuyer());
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBuyerDialog.title", new Object[]{}, locale.getCurrentLocal()));
        initializeButtons();
        IBuyer buyer = (IBuyer) currentPerson.get();
        String iconTemplate;
        if (buyer.getWare().isBarrelSizedWare()) {
            iconTemplate = "icon:Barrel";
        } else {
            iconTemplate = "icon:Bale";
        }

        int p = buyer.getAmountablePrice().getAVGPrice()*buyer.getAmountablePrice().getAmount();
        String loadedText = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBuyerDialog.dialog", new Object[]{iconTemplate}, locale.getCurrentLocal());
        HashMap<String, Object> parameters = new HashMap<>();
        parameters.put("name", buyer.getName());
        parameters.put("amount", buyer.getAmountablePrice().getAmount());
        parameters.put("ware", translator.getLocalDisplayName((EWare)buyer.getWare()));
        parameters.put("price", p);
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);

        getContent().addAll(dt);
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent mouseEvent) {
                final IBuyer buyer = (IBuyer) currentPerson.get();
                timedTaskList.add(taskFactory.getBuyWares(city, buyer));
                buyer.leave();
                executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding() {
            @Override
            protected boolean computeValue() {
                return false;
            }
        };
    }

}
