package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.IConcurrent;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Random;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 27, 2013
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernConcurrentDialog extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private Random rnd;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private ClientTaskFactory taskFactory;

    public TavernConcurrentDialog(Font font, ICityPlayerProxyJFX city) {
        super(font, city, city.getCity().getCityState().getTavernState().getConcurrent());
        setTitle(((IConcurrent)currentPerson.get()).getName());
    }
    @PostConstruct
    private void initializeDialog() {
        initializeButtons();
        IConcurrent concurrent = (IConcurrent) currentPerson.get();

        String loadedText = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernConcurrentDialog.dialog", new Object[]{}, locale.getCurrentLocal());
        HashMap<String, Object> parameters = new HashMap<>();
        parameters.put("name", city.getPlayer().getLastName());
        parameters.put("concurrent", concurrent.getName());
        parameters.put("price", concurrent.getPremium());
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);

        getContent().addAll(dt);
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent mouseEvent) {
                IConcurrent concurrent = (IConcurrent) currentPerson.get();
                int minutes = rnd.nextInt(600);
                DateTime postMessage = date.getCurrentDate().plusMinutes(minutes);
                String message = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernConcurrentDialog.acceptMessage", new Object[]{concurrent.getConcurrentName()}, locale.getCurrentLocal());
                taskFactory.getPostponedDisplayMessage(postMessage, message);
                TimedTask reconsialistation = taskFactory.getConcurrentReconciliation();
                // Order of the client to sink the opponents ship
                eventHandlerFactory.getSinkConcurrentsShipOrder(concurrent.getConcurrentPlayer(), city.getPlayer(), 20, concurrent.getPremium(), reconsialistation);
                // Postponed order of the opponent to sink the clients ship
                taskFactory.getOpponentsOrder(concurrent.getConcurrentPlayer(), concurrent.getClientPlayer(), city.getPlayer(), concurrent.getPremium()*2);
                concurrent.leave();
                executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding() {
            @Override
            protected boolean computeValue() {
                return false;
            }
        };
    }

}
