package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.datastructure.GenericPair;
import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.util.TavernDialogUtil;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IInformant;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 28, 2013
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernInformantDialogPageTwo extends CloseButtonDialog {
    private final ICityPlayerProxyJFX city;
    private final Font font;
    private final IInformant informant;
    @Autowired
    private TavernDialogUtil tavernDialogUtil;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;

    private final TavernState tavernState;
    private ChangeListener<Boolean> leaving;

    public TavernInformantDialogPageTwo(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
        tavernState = city.getCity().getCityState().getTavernState();
        informant =  tavernState.getInformant();
    }
    @PostConstruct
    private void initializeDialog() {


        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernInformantDialogPageOne.title", new Object[]{informant.getName()}, locale.getCurrentLocal()));

        StringBuffer template  = new StringBuffer();
        HashMap<String, Object> parameters = new HashMap<>();
        if (informant.getWareNeeded().isPresent()) {
            GenericPair<ICity, IWare> needed = informant.getWareNeeded().get();

            template.append(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernInformantDialogPageTwo.dialog1", new Object[]{needed.getFirst().getName(), translator.getLocalDisplayName((EWare) needed.getSecond())}, locale.getCurrentLocal()));

        }
        if (informant.getWareSurplus().isPresent()) {
            GenericPair<ICity, IWare> surplus = informant.getWareSurplus().get();

            template.append(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernInformantDialogPageTwo.dialog2", new Object[]{surplus.getFirst().getName(), translator.getLocalDisplayName((EWare) surplus.getSecond())}, locale.getCurrentLocal()));
        }
        final Optional<MapSegmentedImage> mapSectionPart = informant.getMapSectionPart(city.getPlayer());
        if (mapSectionPart.isPresent()) {
            List<Integer> visibleSegs = new ArrayList<>();
            visibleSegs.addAll(mapSectionPart.get().getSegmentIndices());
            parameters.put("visibleSegments", visibleSegs);
            template.append(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernInformantDialogPageTwo.dialog4", new Object[]{mapSectionPart.get().getImageName()}, locale.getCurrentLocal()));
        }
        if (informant.getPirateLocation().isPresent()) {
            GenericPair<String, ICity> pirate = informant.getPirateLocation().get();
            template.append(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernInformantDialogPageTwo.dialog3", new Object[]{pirate.getFirst(), pirate.getSecond().getName()}, locale.getCurrentLocal()));
        }

        DecoratedText dt = decoratedTextFactory.createDecoratedText(template.toString(), parameters);
        leaving = (observable, oldValue, newValue) -> {
            if (!newValue) { // the person became unavailable
                executeOnCloseButtonClicked();
            }
        };
        informant.isPresentProperty().addListener(new WeakChangeListener<>(leaving));

        getContent().addAll(dt);
    }

    /**
     * Update the notice board and close the dialog.
     */
    @Override
    protected void executeOnCloseButtonClicked() {
        tavernDialogUtil.stopTalkingToPerson(tavernState, city.getPlayer());
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_TAVERN);
        clientEventBus.post(new NoticeBoardUpdate(proxy));
        super.executeOnCloseButtonClicked();
    }
}
