package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.people.ITransportTrader;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

import static com.google.common.collect.Lists.newArrayList;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 26, 2013
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernTransportTraderDialog extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private Random rnd;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;

    public TavernTransportTraderDialog(Font font, ICityPlayerProxyJFX city) {
        super(font, city, city.getCity().getCityState().getTavernState().getTransportTrader());
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTransportTraderDialog.title", new Object[]{}, locale.getCurrentLocal()));
        initializeButtons();
        ITransportTrader trader = (ITransportTrader) currentPerson.get();

        String loadedText = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTransportTraderDialog.dialog", new Object[]{city.getCity().getName(), trader.getDestination().getName()}, locale.getCurrentLocal());


        HashMap<String, Object> parameters = new HashMap<>();
        parameters.put("amount", trader.getNeededCapacity());
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);


        getContent().addAll(dt);
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent mouseEvent) {
                List<IShip> ships = newArrayList(city.getPlayersShips()); // we need a copy
                Collections.shuffle(ships);
                ITransportTrader trader = (ITransportTrader) currentPerson.get();
                for (IShip ship : ships) {
                    final int neededCapacity = trader.getNeededCapacity();
                    if (ship.getCapacity() > neededCapacity *10) {
                        ship.setOccupiedSpace(neededCapacity);
                        String s = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTransportTraderDialog.acceptMessage", new Object[]{trader.getDestination().getName(), ship.getName()}, locale.getCurrentLocal());
                        int minutes = rnd.nextInt(600);
                        DateTime postMessage = date.getCurrentDate().plusMinutes(minutes);
                        taskFactory.getPostponedDisplayMessage(postMessage, s);
                        trader.leave();
                        eventHandlerFactory.getUnloadOnArrivalHandler(ship, trader.getDestination(), neededCapacity);
                        break;
                    }
                }
                executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding() {
            {
                super.bind(city.getPlayersShips());
                // todo: andi 23/12/13: should not consider ships that are automated in some way (these are the ships which's capacity may change)
            }
            @Override
            protected boolean computeValue() {
                ITransportTrader trader = (ITransportTrader) currentPerson.get();
                return tavernDialogUtil.noShipWithEnoughCapacityAvailable(city, trader.getNeededCapacity());
            }
        };
    }

}
