package ch.sahits.game.graphic.display.dialog.util;
/**
 * Enumeration of all dialogs.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 23, 2013
 *
 */
public enum EDialogType {
	/** Trading office balance sheet */
	TO_BALANCE,
	/** Trading office personal data */
	TO_PERSONAL,
	/** Trading office consumtion and production */
	TO_CONSUMPTION_PRODUCTION,
	/** Trading office ware houses */
	TO_WAREHOUSES,
	/** Trading office automatic trading */
	TO_OFFICE_TRADING,
	/** Trading office weapons */
	TO_WEAPONS,
	/** Transfer between city and a ship */
	CITY_TO_SHIP,
	/** Transfer between city and the trading office */
	CITY_TO_STORAGE,
	/** Transfer between the trading office and a ship */
	STORAGE_TO_SHIP,
	/** Transfer weapons from storage to the ship */
	WEAPON,
    /** Market booth stock and prices */
    MB_STOCK_PRICES,
    /** Market booth consumtion and production */
    MB_CONSUMPTION_PRODUCTION,
    /** Ware buyer in the tavern */
    TAVERN_BUYER,
    /** Sailor hiring in the tavern */
    TAVERN_SAILORS,
    /** Weapons dealer in the tavern */
    TAVERN_WEAPONS_DEALER,
    /** Informant first dialog in the tavern */
    TAVERN_INFORMANT_1,
    /** Informant second dialog in the tavern */
    TAVERN_INFORMANT_2,
    /** Captain sitting in the tavern */
    TAVERN_CAPTAIN,
    /** Pirate sitting in the tavern. */
    TAVERN_PIRATE,
    /** Traveler sitting in the tavern. */
    TAVERN_TRAVELER,
    /** Enter side room in tavern */
    TAVERN_SIDE_ROOM,
    /** Courier */
    TAVERN_COURIER,
    /** Remote trading */
    TAVERN_TRANSPORT_TRADER,
    /** Escorte */
    TAVERN_ESCORTE,
    /** Fugative */
    TAVERN_FUGATIVE,
    /** Patrol */
    TAVERN_PATROL,
    /** Burglar */
    TAVERN_BURGLAR,
    /** Concurrent */
    TAVERN_CONCURRENT,
    /** Owner of a map with a pirate nest */
    TAVERN_PIRATE_HUNTER,
    /** Warehouse tenant */
    TAVERN_WAREHOUSE_TENANT,
    /** Smuggler */
    TAVERN_SMUGGLER,
    /** Owner of a treasuremap part */
    TAVERN_TREASUREMAP_OWNER,
    /** Local trader selling wares from the city */
    TAVERN_TRADER,
    /** Build a new ship */
    SHIPYARD_CONSTRUCTION,
    /** Repair a ship */
    SHIPYARD_REPAIR,
    /** Rename a ship. */
    SHIPYARD_RENAME,
    /** Display the construction list */
    SHIPYARD_CONSTRUCTION_LIST,
    /** Display the repair list */
    SHIPYARD_REPAIR_LIST,
    /** Upgrade a ship. */
    SHIPYARD_UPGRADE,
    /** Take a loan */
    LOANER_TAKE,
    /** Give a loan */
    LOANER_GIVE,
    /** Repay a loan */
    LOANER_REPAY,
    /** List given loans */
    LOANER_LIST,
    /** Public notice in the city hall */
    CITY_HALL_NOTICE,
    /** Outrigger notice in the city hall */
    CITY_HALL_OUTRIGGER,
    /** Town information */
    CITY_HALL_TOWN_INFO,
    /** City treasury */
    CITY_HALL_TREASURY,
    /** Hanseatic information */
    CITY_HALL_HANSEATIC_INFO,
    /** Aldermans office */
    CITY_HALL_ALDERMAN_OFFICE,
    /** Meeting room */
    CITY_HALL_MEETING_ROOM,
    /** City wall building */
    CITY_HALL_CITY_WALL,
    CHURCH_FEED,
    CHURCH_GIFT,
    CHURCH_EXTENSION,
    /** Hisrory dialog of the current city */
    CITY_HISTORY
}
