package ch.sahits.game.graphic.display.gameplay.internal;


import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.eventbus.AsyncEventBus;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
/**
 * Component initializing the polygons for the port scene
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 10, 2013
 *
 */
@Component
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class PortScenePolygonInitializer extends ScenePolygonInitialzer {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

	public PortScenePolygonInitializer(){
		super("images/scene/portScene");
	}
	@Override
	protected EventHandler<MouseEvent> createEventHandler(final String name) {
		switch (name) {
		case "shipYard": {
			return new EventHandler<MouseEvent>() {

				@Override
				public void handle(MouseEvent arg0) {
					ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_SHIPYARD);
                    clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
				}
			};
		}
		case "tavern": {
			return new EventHandler<MouseEvent>() {

				@Override
				public void handle(MouseEvent arg0) {
					ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_TAVERN);
                    clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
					proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_TAVERN);
                    clientEventBus.post(new NoticeBoardUpdate(proxy));
				}
			};
		}
		case "LoadingCrane": {
			return new EventHandler<MouseEvent>() {

				@Override
				public void handle(MouseEvent arg0) {
					ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_TRADE);
                    clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
					proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_TRADE);
					clientEventBus.post(new NoticeBoardUpdate(proxy));
				}
			};
		}
		case "Stairs": {
			// replace the scene with the market scene
			return new EventHandler<MouseEvent>() {

				@Override
				public void handle(MouseEvent arg0) {
					ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_MARKET);
                    clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
				}
			};
		}
		case "Loaner": {
			// replace the scene with the market scene
			return new EventHandler<MouseEvent>() {

				@Override
				public void handle(MouseEvent arg0) {
					ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_LOANER);
					clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
					proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_LOANER);
					clientEventBus.post(new NoticeBoardUpdate(proxy));
				}
			};
		}
		case "TradingOffice": {
			return new EventHandler<MouseEvent>() {

				@Override
				public void handle(MouseEvent arg0) {
					ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_TRADING_OFFICE);
                    clientEventBus.post(new NoticeBoardUpdate(proxy));
                    clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
				}
			};
		}
		default:
			throw new IllegalStateException("Unhandled polygon action: "+name);
		}
	}

}
