package ch.sahits.game.graphic.display.util;

import ch.sahits.game.event.EGameStatusChange;
import ch.sahits.game.event.GameStateChange;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.persistence.LoadAndSaveService;
import ch.sahits.game.openpatrician.util.GamePropertyUtility;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Helper service for common option tasks.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 27, 2014
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class GameOptionsService {

    private static final String SAVEGAME_DIR = GamePropertyUtility.APP_CONF_DIR+ File.separatorChar+"savegames";
    private static final String SAVEGAME_FILE_EXTENSTION = ".ops";
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private LoadAndSaveService loadAndSave;
    private File savegameDir;
    @Autowired
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    @PostConstruct
    private void init() {
        File userHome = new File(System.getProperty("user.home"));
        savegameDir = new File(userHome, SAVEGAME_DIR);
        if (!savegameDir.exists()) {
            savegameDir.mkdir();
        }
    }
    /**
     * Compile a list of game speeds
     * @return
     */
    public List<String> getGameSpeedList() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.break", new Object[]{}, locale.getCurrentLocal())); // TODO utilize EGameSpeed
        l.add(messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.slow", new Object[]{}, locale.getCurrentLocal()));
        l.add(messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.normal", new Object[]{}, locale.getCurrentLocal()));
        l.add(messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.fast", new Object[]{}, locale.getCurrentLocal()));
        return l;
    }

    /**
     * Retrieve the list of savegames.
     * @return
     */
    public Map<String, String> getSavegames() {
        FilenameFilter filter = new FilenameFilter() {
            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(SAVEGAME_FILE_EXTENSTION);
            }
        };
        String[] savegames = savegameDir.list(filter);
        Map<String, String> map = new HashMap<>();
        for (String savegame : savegames) {
            String savegameName = savegame.substring(0, savegame.indexOf('.'));
            map.put(savegameName, savegameName);
        }

        return map;
    }

    public void save(String savegameName) {
        String fileName = savegameDir + File.separator + savegameName + SAVEGAME_FILE_EXTENSTION;
        loadAndSave.serialize(fileName);
    }

    public void load(String savegameName) {
        String fileName = savegameDir + File.separator + savegameName + SAVEGAME_FILE_EXTENSTION;
        loadAndSave.restore(fileName);
        clientServerEventBus.post(new GameStateChange(EGameStatusChange.GAME_LOADED));
        // todo: andi 7/22/15: fire the even to start the game
    }

}
