package ch.sahits.game.graphic.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import com.google.common.eventbus.AsyncEventBus;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;

/**
 * Post a displayed message, but postpone it.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Feb 23, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.DEPENDS_ON_SERIALIZED_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class PostponedDisplayMessage extends TimedTask {

	private final String message;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;


	public PostponedDisplayMessage(DateTime executionTime, String message) {
		super();
        setExecutionTime(executionTime);
		this.message = message;
	}
    @PostConstruct
    private void initialize() {
        taskList.add(this);
    }


	@Override
	public void run() {
		DisplayMessage msg = new DisplayMessage(message);
        clientEventBus.post(msg);
	}

}
