package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.javafx.control.DisplayMessageOverlayLabel;
import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.util.Timer;
import java.util.TimerTask;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Mar 04, 2015
 */
@LazySingleton
@ClassCategory(EClassCategory.HANDLER)
public class DisplayMessageOverlay extends VBox {

    private final static int DISPLAY_MESSAGE_FOR_SECONDS = 15;

    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    @Qualifier("uiTimer")
    private Timer uiTimer;
    @Autowired
    private TextSizingUtility sizeing;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;

    public DisplayMessageOverlay() {
    }
    @PostConstruct
    private void init() {
        clientEventBus.register(this);
    }
    @PreDestroy
    private void unregister() {
        clientEventBus.unregister(this);
    }
    @Subscribe
    public void handleMessage(DisplayMessage message) {
        System.out.println("Caught display message: "+message.getMessage());
        DisplayMessageOverlayLabel label = new DisplayMessageOverlayLabel(message.getMessage(), sizeing);
        if (message.hasDialogTemplate()) {
            label.setLinkText(true);
            EventHandler<MouseEvent> openDialogEvenHandler = createEventHandlerFromRunnable(eventHandlerFactory.getViewChangeActionRunnable(message.getDialogTemplate()));
            label.setOnMouseReleased(openDialogEvenHandler);
        }
        TimerTask task = new TimerTask() {
            @Override
            public void run() {
                Platform.runLater(() -> {
                    getChildren().remove(label);
                });
            }
        };

        uiTimer.schedule(task, DISPLAY_MESSAGE_FOR_SECONDS * 1000);
        Platform.runLater(() -> {
            getChildren().add(0, label);
        });
    }

    /**
     * Helper method to convert the old event triggering into JavaFX events.
     * @param run
     * @return
     */
    private EventHandler<MouseEvent> createEventHandlerFromRunnable(final Runnable run) {
        return new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent arg0) {
                run.run();
            }
        };

    }
}
