package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.graphic.display.gameplay.internal.EScene;
import ch.sahits.game.javafx.control.ViewStatus;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 12, 2013
 */
@Service
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class SceneEventHandlerFactory {
    @ObjectPropertyType(EScene.class)
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty<>(this, "currentScene", EScene.PORT);
    @Autowired
    private PortSceneEventHandler portSceneHandler;
    @Autowired
    private MarketSceneEventHandler marketSceneHandler;
    @Autowired
    private ShipyardSceneEventHandler shipyardSceneHandler;
    @Autowired
    private TavernSceneEventHandler tavernSceneHandler;
    @Autowired
    private CityHallSceneEventHandler cityHallSceneEventHandler;
    @Autowired
    private LoanerSceneEventHandler loanerSceneEventHandler;
    @Autowired
    private ChurchSceneEventHandler churchSceneEventHandler;
    @Autowired
    private ViewStatus viewStatus;
    @PostConstruct
    private void initializeBinding() {
        portSceneHandler.currentSceneProperty().bindBidirectional(currentScene);
        marketSceneHandler.currentSceneProperty().bindBidirectional(currentScene);
        shipyardSceneHandler.currentSceneProperty().bindBidirectional(currentScene);
        tavernSceneHandler.currentSceneProperty().bindBidirectional(currentScene);
        cityHallSceneEventHandler.currentSceneProperty().bindBidirectional(currentScene);
        loanerSceneEventHandler.currentSceneProperty().bindBidirectional(currentScene);
        churchSceneEventHandler.currentSceneProperty().bindBidirectional(currentScene);
    }
    public ObjectProperty<EScene> currentSceneProperty() {
        return currentScene;
    }

    public void setUpDialogController(IDialogContoller controller){
        portSceneHandler.setDialogContoller(controller);
        marketSceneHandler.setDialogContoller(controller);
        shipyardSceneHandler.setDialogContoller(controller);
        tavernSceneHandler.setDialogContoller(controller);
        cityHallSceneEventHandler.setDialogContoller(controller);
        loanerSceneEventHandler.setDialogContoller(controller);
        churchSceneEventHandler.setDialogContoller(controller);
        viewStatus.setDialogContoller(controller);
    }

    public ISceneEventHandler getSceneEventHandler() {
        switch (currentScene.get()) {
            case PORT:
                return portSceneHandler;
            case MARKET:
                return marketSceneHandler;
            case SHIPYARD:
                return shipyardSceneHandler;
            case TAVERN:
                return tavernSceneHandler;
            case CITY_HALL:
                return cityHallSceneEventHandler;
            case LOANER:
                return loanerSceneEventHandler;
            case CHURCH:
                return churchSceneEventHandler;
            default:
                throw new IllegalStateException("Unsupported scene: "+currentScene.get());
        }
    }
}
