package ch.sahits.game.javafx.control;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NavigationStateChange;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.OpenPaticianApplicationWindow;
import ch.sahits.game.graphic.display.SceneChangeable;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.display.scene.InGameOptionsScene;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.sound.ITrackPlayer;
import ch.sahits.game.util.UIFactory;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

/**
 * Control representing the main menu.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 1, 2013
 *
 */
@ClassCategory({EClassCategory.JAVAFX, EClassCategory.SINGLETON_BEAN})
public class MainMenu extends Group {
	private final Logger logger = LogManager.getLogger(getClass());
	@Autowired
	@Qualifier("mainScreenXMLImageLoader")
	private IDataImageLoader imageLoader;
	@Autowired
	private UIFactory uiFactory;
	@Autowired
	private ClientViewState viewState;
	@Autowired
	@Qualifier("clientEventBus")
	private AsyncEventBus clientEventBus;
	@Autowired
	private ITrackPlayer soundPlayer;

	private boolean navigationDisabled = false;

	private SceneChangeable sceneChangeable;
	public MainMenu() {
		setManaged(false);
	}
	@PreDestroy
	private void unregister() {
		clientEventBus.unregister(this);
	}
	@PostConstruct
	private void initializeControls() {
		clientEventBus.register(this);
		sceneChangeable = OpenPaticianApplicationWindow.getApplication();
		HBox iconBar = new HBox(2);

		final ImageView messagesGraphic = new ImageView(imageLoader.getImage("icons/64/paperscrolls-icon"));
		Label messages = new Label();
		messages.setGraphic(messagesGraphic);
		messages.setScaleX(0.5);
		messages.setScaleY(0.5);
		messages.setOnMouseReleased(new EventHandler<MouseEvent>() {
			@Override
			public void handle(MouseEvent mouseEvent) {
				if (!navigationDisabled) {
					ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MESSAGES);

					NoticeBoardUpdate noticeBoardUpdate = new NoticeBoardUpdate(proxy);
					clientEventBus.post(noticeBoardUpdate);
				}
			}
		});

		final ImageView optionsGraphic = new ImageView(imageLoader.getImage("icons/64/anchor"));
		Label options = new Label();
		options.setGraphic(optionsGraphic);
		options.setScaleX(0.5);
		options.setScaleY(0.5);
		options.setOnMouseReleased(new EventHandler<MouseEvent>() {
			@Override
			public void handle(MouseEvent mouseEvent) {
				if (!navigationDisabled) {
					soundPlayer.stop();
					InGameOptionsScene options = uiFactory.getInGameOptionsScene();
					options.initializeState();
					options.setSceneChangeable(sceneChangeable);
					sceneChangeable.changeScene(options);
				}

			}
		});

		iconBar.getChildren().addAll(messages, options);
		iconBar.setLayoutX(-12); // this is due to the scaling, the bounds do not change.
		iconBar.setLayoutY(-12);
		getChildren().addAll(iconBar);

	}

	@Subscribe
	public void handleNAvigationChange(NavigationStateChange event) {
		switch (event.getChange()) {
			case DISABLE_NAVIGATION:
				navigationDisabled = true;
				break;
			case ENABLE_NAVIGATION:
				navigationDisabled = false;
				break;
			default:
				logger.info("Not interested in navigation change event: "+event.getChange());
		}
	}
}
