package ch.sahits.game.javafx.control;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.util.DialogFactory;
import ch.sahits.game.graphic.display.dialog.util.EDialogType;
import ch.sahits.game.graphic.javafx.display.IDialogContoller;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.util.IRebinabable;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * Status control displaying the city name.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 2, 2013
 *
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class ViewStatus extends Group implements IRebinabable {
    private final Logger logger = LogManager.getLogger(getClass());

	private StringProperty city;
	private DoubleProperty width;
	// // TODO aho Sep 21, 2013: replace with stylable with JavaFX 8
	private Text cityName;
	@Autowired
	private ClientViewState clientViewState;
    @Autowired
    private DialogFactory dialogFactory;

	@Autowired
	@Qualifier("clientEventBus")
	protected AsyncEventBus clientEventBus;

    private IDialogContoller dialogContoller; // this instance exists not at startup
	public ViewStatus() {
		setManaged(false);
        getStylesheets().add(getClass().getResource(getClass().getSimpleName() + ".css").toExternalForm());
		city = new SimpleStringProperty(this, "city", "");
		width = new SimpleDoubleProperty(this, "controlWidth", 0);
		cityName = new Text();
		cityName.setFill(Color.WHITE);
		cityName.getStyleClass().add("cityName");
		cityName.textProperty().bind(city);
		cityName.setOnMouseReleased(createHistoryDisplayHandler());  // handler to close any open dialog and open a history dialog
		Rectangle placeholder = new Rectangle(width.doubleValue(), 50);
		placeholder.setFill(Color.TRANSPARENT);
		placeholder.widthProperty().bind(width);
		StackPane centering = new StackPane();
		centering.prefWidthProperty().bind(width);
		centering.getChildren().add(cityName);
		getChildren().addAll(placeholder, centering);
	}
    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }
	private EventHandler<? super MouseEvent> createHistoryDisplayHandler() {
		return new EventHandler<MouseEvent>() {
			@Override
			public void handle(MouseEvent mouseEvent) {
                if (clientViewState.getCurrentCityProxy().isPresent()) {
					clientEventBus.post(new NoticeBoardClose());
					dialogContoller.replaceDialog(EDialogType.CITY_HISTORY);
                }
			}
		};
	}

    private String getHistoryResourceName(String name) {
        return "history."+name;
    }


	public void setCity(String city) {
		this.city.set(city);
	}
	public String getCity() {
		return this.city.get();
	}
	
	public StringProperty cityProperty() {
		return city;
	}
	
	public DoubleProperty widthProperty() {
		return width;
	}
	
	public void setWidth(double width) {
		this.width.set(width);
	}
	public double getWidth() {
		return width.doubleValue();
	}
	public void setFont(Font f) {
		cityName.setFont(f);
	}

    @Override
    public void rebind() {
        city.setValue(clientViewState.getCurrentCityProxy().get().getCity().getName());
    }
}
