/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game;

import ch.sahits.game.CommandLineArguments;
import ch.sahits.game.graphic.display.OpenPaticianApplicationWindow;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.server.ServerLauncher;
import ch.sahits.game.openpatrician.spring.StandaloneConfiguration;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;

@ClassCategory(value={EClassCategory.STARTUP})
public class OpenPatrician {
    private static Logger logger = LogManager.getLogger(OpenPatrician.class);
    private static volatile boolean startedServer = false;
    private static final Object lock = new Object();

    public static void main(String[] args) {
        String jreVersion = (String)System.getProperties().get("java.version");
        if (!jreVersion.startsWith("1.8")) {
            logger.error("JRE must be of version 1.8");
            System.out.println("JRE must be of version 1.8");
            System.exit(1);
        }
        OpenPatrician.logEnvironment();
        CommandLineArguments cmdHelper = new CommandLineArguments();
        Options opts = cmdHelper.createCommandLineOptions();
        CommandLine cmdLine = cmdHelper.parseCommandLine(opts, args);
        if (cmdLine.hasOption("h")) {
            cmdHelper.printHelp(opts);
            System.exit(0);
        }
        if (cmdLine.hasOption("version")) {
            System.out.println("OpenPatrician version: " + OpenPatrician.class.getPackage().getImplementationVersion());
            System.exit(0);
        }
        cmdHelper.persistAsPropertyFile(cmdLine);
        if (cmdHelper.isServer(cmdLine)) {
            logger.error("Multiplayer game is not yet implemented, sorry.");
            System.exit(0);
        } else {
            if (cmdHelper.isStandalone(cmdLine)) {
                ServerLauncher.initializeApplicationContext(StandaloneConfiguration.class);
            }
            OpenPaticianApplicationWindow.startClientUI(new String[0]);
        }
    }

    private static void logEnvironment() {
        Properties sysprops = System.getProperties();
        LoggerContext logContext = (LoggerContext)LogManager.getContext();
        if (logger.isInfoEnabled()) {
            logger.info("Logging into file: " + ((RollingFileAppender)logContext.getConfiguration().getAppender("FileAppender")).getFileName());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Java VM version").append(": ").append(sysprops.get("java.vm.version"));
        if (logger.isInfoEnabled()) {
            logger.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("Java runtime version").append(": ").append(sysprops.get("java.runtime.version"));
        if (logger.isInfoEnabled()) {
            logger.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("Java VM vendor").append(": ").append(sysprops.get("java.vm.vendor"));
        if (logger.isInfoEnabled()) {
            logger.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("Java VM name").append(": ").append(sysprops.get("java.vm.name"));
        if (logger.isInfoEnabled()) {
            logger.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("Java version").append(": ").append(sysprops.get("java.version"));
        if (logger.isInfoEnabled()) {
            logger.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("Java specification version").append(": ").append(sysprops.get("java.specification.version"));
        if (logger.isInfoEnabled()) {
            logger.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("Graphics environment").append(": ").append(sysprops.get("java.awt.graphicsenv"));
        if (logger.isInfoEnabled()) {
            logger.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("User country").append(": ").append(sysprops.get("user.country"));
        if (logger.isInfoEnabled()) {
            logger.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("User language").append(": ").append(sysprops.get("user.language"));
        if (logger.isInfoEnabled()) {
            logger.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("OS architecture").append(": ").append(sysprops.get("os.arch"));
        if (logger.isInfoEnabled()) {
            logger.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("OS name").append(": ").append(sysprops.get("os.name"));
        if (logger.isInfoEnabled()) {
            logger.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("OS version").append(": ").append(sysprops.get("os.version"));
        if (logger.isInfoEnabled()) {
            logger.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("Start command").append(": ").append(sysprops.get("sun.java.command"));
        if (logger.isInfoEnabled()) {
            logger.info(sb.toString());
        }
    }
}

