/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.data.CourierPatrolStateInternal;
import ch.sahits.game.event.data.PatrolInternalState;
import ch.sahits.game.event.handler.IAttackListener;
import ch.sahits.game.event.handler.impl.AttackListener;
import ch.sahits.game.event.handler.impl.DeliverPackages;
import ch.sahits.game.event.handler.impl.NextCourierPatrolStation;
import ch.sahits.game.event.handler.impl.NextPatrolStation;
import ch.sahits.game.event.handler.impl.PassengerLeavesShipOnArival;
import ch.sahits.game.event.handler.impl.ShipArrivalForLoading;
import ch.sahits.game.event.handler.impl.SinkConcurrentsShipOrder;
import ch.sahits.game.event.handler.impl.TavernDialogChangeAction;
import ch.sahits.game.event.handler.impl.TavernDialogTalkToSideroomPersonAction;
import ch.sahits.game.event.handler.impl.UnloadOnArival;
import ch.sahits.game.event.handler.impl.ViewChangeActionRunnable;
import ch.sahits.game.event.handler.impl.ViewChangeDialogTemplateRunnable;
import ch.sahits.game.graphic.display.notice.ENoticeItem;
import ch.sahits.game.javafx.control.DisplayMessageOverlayLabel;
import ch.sahits.game.javafx.control.ScrollPaneContent;
import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.javafx.util.INoticeBoardDestinction;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.dialog.DialogTemplate;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.ship.IShip;
import java.util.Iterator;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class EventHandlerFactory {
    @Autowired
    private ApplicationContext context;
    @Autowired
    private TextSizingUtility sizeing;

    public DeliverPackages getDeliverPackagesHandler(ICity city, IShip ship, DateTime deadline, int premium, int amount) {
        Object[] args = new Object[]{city, ship, deadline, premium, amount};
        return (DeliverPackages)((Object)this.context.getBean("deliverPackages", args));
    }

    public ShipArrivalForLoading getShipArrivalForLoadingHandler(ICity city, IPlayer player, DateTime deadline, int requiredAmount, int premium) {
        Object[] args = new Object[]{city, player, deadline, requiredAmount, premium};
        return (ShipArrivalForLoading)((Object)this.context.getBean("shipArrivalForLoading", args));
    }

    public PassengerLeavesShipOnArival getPassengerLeavingOnShipArrivalHandler(IShip ship, ICity city, IPlayer shipsOwner, int premium) {
        Object[] args = new Object[]{ship, city, shipsOwner, premium};
        return (PassengerLeavesShipOnArival)((Object)this.context.getBean("passengerLeavesShipOnArival", args));
    }

    public UnloadOnArival getUnloadOnArrivalHandler(IShip ship, ICity city, int loadedAmount) {
        return (UnloadOnArival)((Object)this.context.getBean("unloadOnArival", new Object[]{ship, city, loadedAmount}));
    }

    public NextCourierPatrolStation getNextCourierPatrolStationHanlder(IShip ship, ICity city, CourierPatrolStateInternal state, IPlayer player, DateTime deadline) {
        Object[] args = new Object[]{ship, city, state, player, deadline};
        return (NextCourierPatrolStation)((Object)this.context.getBean("nextCourierPatrolStation", args));
    }

    public ViewChangeActionRunnable getViewChangeActionRunnable(ENoticeItem selected) {
        Object[] args = new Object[]{selected};
        return (ViewChangeActionRunnable)this.context.getBean("viewChangeActionRunnable", args);
    }

    public ViewChangeActionRunnable getViewChangeActionRunnable(INoticeBoardDestinction selected) {
        Object[] args = new Object[]{selected};
        return (ViewChangeActionRunnable)this.context.getBean("viewChangeActionRunnable", args);
    }

    public ViewChangeDialogTemplateRunnable getViewChangeActionRunnable(DialogTemplate template) {
        Object[] args = new Object[]{template};
        return (ViewChangeDialogTemplateRunnable)this.context.getBean("viewChangeDialogTemplateRunnable", args);
    }

    public Runnable createNOPRunnable() {
        return new Runnable(){

            @Override
            public void run() {
            }
        };
    }

    public EventHandler<MouseEvent> getDisplaMessageMouseEnterFocusEventHandler(ScrollPaneContent content, final String message) {
        final Group viewContainer = (Group)((StackPane)content.getScene().getRoot()).getChildren().get(1);
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                DisplayMessageOverlayLabel label = new DisplayMessageOverlayLabel(message, EventHandlerFactory.this.sizeing);
                double y = event.getSceneY();
                label.setLayoutY(y);
                label.setLayoutX(350.0);
                viewContainer.getChildren().add((Object)label);
            }
        };
    }

    public EventHandler<MouseEvent> getDisplayMessageMouseExitFocusEventHandler(ScrollPaneContent content) {
        final Group viewContainer = (Group)((StackPane)content.getScene().getRoot()).getChildren().get(1);
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Iterator iterator = viewContainer.getChildren().iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    if (!(node instanceof DisplayMessageOverlayLabel)) continue;
                    iterator.remove();
                    break;
                }
            }
        };
    }

    public TavernDialogTalkToSideroomPersonAction getTavernTalkToSidreroomPersonAction(IPerson showingPerson, TavernState tavernState, IPlayer player) {
        Object[] args = new Object[]{showingPerson, tavernState, player};
        return (TavernDialogTalkToSideroomPersonAction)this.context.getBean("tavernDialogTalkToSideroomPersonAction", args);
    }

    public TavernDialogChangeAction getTavernChangeActionHandler(IPerson showingPerson, TavernState tavernState, IPlayer currentPlayer) {
        Object[] args = new Object[]{showingPerson, tavernState, currentPlayer};
        return (TavernDialogChangeAction)this.context.getBean("tavernDialogChangeAction", args);
    }

    public IAttackListener getAttackListener(IShip ship, PatrolInternalState state) {
        Object[] args = new Object[]{ship, state};
        return (AttackListener)this.context.getBean("attackListener", args);
    }

    public NextPatrolStation getNextPatrolStateion(IShip ship, ICity city, PatrolInternalState state, IPlayer player, DateTime deadline, IAttackListener atackListener) {
        Object[] args = new Object[]{ship, city, state, player, deadline, atackListener};
        return (NextPatrolStation)((Object)this.context.getBean("nextPatrolStation", args));
    }

    public SinkConcurrentsShipOrder getSinkConcurrentsShipOrder(IPlayer opponent, IPlayer player, int offerdTime, int premium, TimedTask reconciliation) {
        Object[] args = new Object[]{opponent, player, offerdTime, premium, reconciliation};
        return (SinkConcurrentsShipOrder)((Object)this.context.getBean("sinkConcurrentsShipOrder", args));
    }
}

