/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.handler.ShipEntersPortEventListener;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class PassengerLeavesShipOnArival
extends ShipEntersPortEventListener {
    private final int premium;
    private final IPlayer shipsOwner;

    public PassengerLeavesShipOnArival(IShip ship, ICity city, IPlayer shipsOwner, int premium) {
        super(ship, city);
        this.premium = premium;
        this.shipsOwner = shipsOwner;
    }

    @PostConstruct
    private void initializeEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregisterEventBus() {
        this.clientServerEventBus.unregister((Object)this);
    }

    public boolean execute() {
        this.getShip().leavePassanger();
        this.shipsOwner.updateCash(this.premium);
        this.unregisterEventBus();
        return true;
    }
}

