/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.notice.ENoticeItem;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.javafx.util.INoticeBoardDestinction;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.HANDLER})
class ViewChangeActionRunnable
implements Runnable {
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    private final ENoticeItem selected;
    private final INoticeBoardDestinction distinction;

    public ViewChangeActionRunnable(ENoticeItem selected) {
        Preconditions.checkNotNull((Object)((Object)selected), (Object)"The notice item my not be null");
        this.selected = selected;
        this.distinction = null;
    }

    public ViewChangeActionRunnable(INoticeBoardDestinction distinction) {
        Preconditions.checkNotNull((Object)distinction, (Object)"The notice item my not be null");
        this.selected = null;
        this.distinction = distinction;
    }

    @Override
    public void run() {
        if (this.selected != null) {
            this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)this.selected));
        } else {
            this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)this.distinction));
        }
    }
}

