/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display;

import ch.sahits.game.event.data.NewGameClient;
import ch.sahits.game.graphic.display.EViewState;
import ch.sahits.game.graphic.display.model.CityPlayerProxyJFX;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.OptionalType;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class ClientViewState {
    @XStreamOmitField
    private final Logger logger = LogManager.getLogger(this.getClass());
    private EViewState state;
    @OptionalType(value=ICityPlayerProxyJFX.class)
    private Optional<ICityPlayerProxyJFX> currentCityProxy;
    private IPlayer player;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;

    @PostConstruct
    private void initEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.logger.debug("Unregister event bus in PreDestroy");
        this.clientServerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void initializeState(NewGameClient newGameDTO) {
        this.player = newGameDTO.getPlayer();
        this.state = EViewState.CITY;
        IShip activeShip = null;
        for (IShip ship : this.player.getFleet()) {
            if (!ship.isAvailable()) continue;
            activeShip = ship;
            break;
        }
        CityPlayerProxyJFX proxy = new CityPlayerProxyJFX(this.player.getHometown(), this.player, activeShip);
        this.currentCityProxy = Optional.of(proxy);
    }

    public EViewState getState() {
        return this.state;
    }

    public Optional<ICityPlayerProxyJFX> getCurrentCityProxy() {
        return this.currentCityProxy;
    }

    public IPlayer getPlayer() {
        return this.player;
    }
}

