/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.graphic.display.dialog.TabelViewDialog;
import ch.sahits.game.graphic.display.dialog.action.BuyJFXProxyAction;
import ch.sahits.game.graphic.display.dialog.action.SellJFXProxyAction;
import ch.sahits.game.graphic.display.dialog.util.EDialogType;
import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.javafx.control.BaleAmount;
import ch.sahits.game.javafx.control.BarrelAmount;
import ch.sahits.game.javafx.control.CoinPrice;
import ch.sahits.game.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.TransferUtil;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.NumberBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

public abstract class BaseTradeDialog
extends TabelViewDialog
implements ITransferableJFX {
    private ObjectProperty<ETransferAmount> movableAmount = new SimpleObjectProperty((Object)ETransferAmount.ONE);
    protected final ICityPlayerProxyJFX city;
    @Autowired
    private TransferUtil transferUtil;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;
    private EDialogType type;
    private Font font;

    public BaseTradeDialog(Font font, ICityPlayerProxyJFX city, EDialogType type) {
        super(font);
        this.city = city;
        this.type = type;
        this.font = font;
    }

    protected abstract Group createSubTitle(Font var1, ICityPlayerProxyJFX var2);

    @PostConstruct
    private void initializeModelAndDialog() {
        Group subTitle = this.createSubTitle(this.font, this.city);
        subTitle.setLayoutX(30.0);
        subTitle.setLayoutY(80.0);
        this.getContent().add((Object)subTitle);
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.title", new Object[0], this.locale.getCurrentLocal()));
        OpenPatricianSmallWaxButton btn1 = new OpenPatricianSmallWaxButton("1", this.font);
        btn1.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                BaseTradeDialog.this.movableAmount.setValue((Object)ETransferAmount.ONE);
            }
        });
        OpenPatricianSmallWaxButton btn5 = new OpenPatricianSmallWaxButton("5", this.font);
        btn5.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                BaseTradeDialog.this.movableAmount.setValue((Object)ETransferAmount.FIVE);
            }
        });
        String max = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.max", new Object[0], this.locale.getCurrentLocal());
        OpenPatricianSmallWaxButton btnMax = new OpenPatricianSmallWaxButton(max, this.font);
        btnMax.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                BaseTradeDialog.this.movableAmount.setValue((Object)ETransferAmount.MAX);
            }
        });
        this.addButtomControlButtons(btn1, btn5, btnMax);
        Table model = this.createModel(this.city, this.font);
        this.setModel(model);
    }

    private Table createModel(ICityPlayerProxyJFX cityProxy, Font font) {
        Table model = new Table();
        TableHeader header = new TableHeader(6);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.ware", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.getTradeFromDestination()));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.buy", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.sell", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.getTradeToDestination()));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.avg-price", new Object[0], this.locale.getCurrentLocal())));
        header.setAligenment(0, HPos.RIGHT);
        header.setAligenment(1, HPos.RIGHT);
        header.setAligenment(2, HPos.CENTER);
        header.setAligenment(3, HPos.CENTER);
        header.setAligenment(4, HPos.RIGHT);
        header.setAligenment(5, HPos.RIGHT);
        model.setHeader(header);
        model.setAligenment(0, HPos.RIGHT);
        model.setAligenment(1, HPos.RIGHT);
        model.setAligenment(2, HPos.LEFT);
        model.setAligenment(3, HPos.LEFT);
        model.setAligenment(4, HPos.RIGHT);
        model.setAligenment(5, HPos.RIGHT);
        model.setColumnWidth(new Integer[]{100, 70, 62, 62, 70, 70});
        ICity city = cityProxy.getCity();
        ITradingOffice office = cityProxy.getPlayer().findTradingOffice(city);
        IShip ship = cityProxy.getActiveShip();
        for (final EWare ware : EWare.values()) {
            TableRow row = new TableRow();
            row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName(ware)));
            IntegerProperty amountAvailableProp = this.getAvailableAmountProperty(city, (IWare)ware, office);
            IntegerBinding amountToTransfer = this.getAmountProperty(city.getWare((IWare)ware).amountProperty());
            if (ware.isBarrelSizedWare()) {
                BarrelAmount barrelAmount = new BarrelAmount(font);
                barrelAmount.amountProperty().bind((ObservableValue)amountAvailableProp.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmount baleAmount = new BaleAmount(font);
                baleAmount.amountProperty().bind((ObservableValue)amountAvailableProp.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            OpenPatricianSmallWaxButton buyBtn = new OpenPatricianSmallWaxButton("", font);
            buyBtn.textProperty().bind((ObservableValue)this.buyPrice((IWare)ware, amountAvailableProp, amountToTransfer));
            buyBtn.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent arg0) {
                    new BuyJFXProxyAction((IWare)ware, BaseTradeDialog.this).run();
                }
            });
            row.add((ITableCell)new ControlTableCell((Node)buyBtn));
            OpenPatricianSmallWaxButton sellBtn = new OpenPatricianSmallWaxButton("", font);
            sellBtn.textProperty().bind((ObservableValue)this.sellPrice((IWare)ware, amountAvailableProp, amountToTransfer));
            sellBtn.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent arg0) {
                    new SellJFXProxyAction((IWare)ware, BaseTradeDialog.this).run();
                }
            });
            row.add((ITableCell)new ControlTableCell((Node)sellBtn));
            IntegerProperty storedAmountProperty = this.getStoredAmountProperty((IWare)ware, ship, office);
            if (ware.isBarrelSizedWare()) {
                BarrelAmount barrelAmount = new BarrelAmount(font);
                barrelAmount.amountProperty().bind((ObservableValue)storedAmountProperty.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmount baleAmount = new BaleAmount(font);
                baleAmount.amountProperty().bind((ObservableValue)storedAmountProperty.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            CoinPrice coinPrice = new CoinPrice(font);
            AmountablePrice<IWare> amountable = this.getStoredAmountablePrice((IWare)ware, ship, office);
            final NumberBinding avgPriceProperty = amountable.avgPriceProperty();
            StringBinding avgPriceStringBinding = new StringBinding(){
                {
                    super.bind(new Observable[]{avgPriceProperty});
                }

                protected String computeValue() {
                    return String.valueOf((int)Math.rint(avgPriceProperty.doubleValue()));
                }
            };
            coinPrice.amountProperty().bind((ObservableValue)avgPriceStringBinding);
            row.add((ITableCell)new ControlTableCell((Node)coinPrice));
            model.add(row);
        }
        return model;
    }

    protected String getTradeFromDestination() {
        return this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.city", new Object[0], this.locale.getCurrentLocal());
    }

    protected String getTradeToDestination() {
        return this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.ship", new Object[0], this.locale.getCurrentLocal());
    }

    private IntegerProperty getStoredAmountProperty(IWare ware, IShip ship, ITradingOffice office) {
        AmountablePrice<IWare> amounable = this.getStoredAmountablePrice(ware, ship, office);
        return amounable.amountProperty();
    }

    private AmountablePrice<IWare> getStoredAmountablePrice(IWare ware, IShip ship, ITradingOffice office) {
        AmountablePrice amounable;
        switch (this.type) {
            case CITY_TO_SHIP: 
            case STORAGE_TO_SHIP: {
                amounable = ship.getWare(ware);
                break;
            }
            case CITY_TO_STORAGE: {
                amounable = office.getWare(ware);
                break;
            }
            default: {
                throw new IllegalStateException("Dialog type " + (Object)((Object)this.type) + " not handled");
            }
        }
        return amounable;
    }

    private IntegerProperty getAvailableAmountProperty(ICity city, IWare ware, ITradingOffice office) {
        AmountablePrice available;
        switch (this.type) {
            case CITY_TO_SHIP: 
            case CITY_TO_STORAGE: {
                available = city.getWare(ware);
                break;
            }
            default: {
                available = office.getWare(ware);
            }
        }
        return available.amountProperty();
    }

    private StringBinding buyPrice(final IWare ware, final IntegerProperty availableAmount, final IntegerBinding amountToBuy) {
        return new StringBinding(){
            {
                super.bind(new Observable[]{availableAmount, amountToBuy});
            }

            protected String computeValue() {
                switch (BaseTradeDialog.this.type) {
                    case CITY_TO_SHIP: 
                    case CITY_TO_STORAGE: {
                        if (availableAmount.get() > 0) {
                            return String.valueOf(ware.buyPrice(availableAmount, amountToBuy));
                        }
                        return "0";
                    }
                }
                return "<";
            }
        };
    }

    private StringBinding sellPrice(final IWare ware, final IntegerProperty availableAmount, final IntegerBinding amountToSell) {
        return new StringBinding(){
            {
                super.bind(new Observable[]{availableAmount, amountToSell});
            }

            protected String computeValue() {
                switch (BaseTradeDialog.this.type) {
                    case CITY_TO_SHIP: 
                    case CITY_TO_STORAGE: {
                        if (BaseTradeDialog.this.movableAmount.get() == ETransferAmount.MAX) {
                            return String.valueOf(ware.getMaxValueSell());
                        }
                        if (amountToSell.get() > 0) {
                            return String.valueOf(ware.sellPrice(availableAmount, amountToSell));
                        }
                        return String.valueOf(ware.getMaxValueSell());
                    }
                }
                return ">";
            }
        };
    }

    private IntegerBinding getAmountProperty(final IntegerProperty maxAmount) {
        return new IntegerBinding(){
            {
                super.bind(new Observable[]{BaseTradeDialog.this.movableAmount, maxAmount});
            }

            protected int computeValue() {
                return BaseTradeDialog.this.transferUtil.calculateAvailableAmount(BaseTradeDialog.this.movableAmount, maxAmount.get());
            }
        };
    }

    @Override
    public ICityPlayerProxyJFX getCityPlayerProxy() {
        return this.city;
    }

    @Override
    public EDialogType getDialogType() {
        return this.type;
    }

    @Override
    public int getAmount(int availableAmountCity) {
        return this.transferUtil.calculateAvailableAmount(this.movableAmount, availableAmountCity);
    }

    @Override
    public ETransferAmount getMovableAmount() {
        return (ETransferAmount)this.movableAmount.get();
    }
}

