/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.graphic.display.dialog.ParentNodeProvider;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.javafx.control.PlaceHolder;
import ch.sahits.game.openpatrician.dialog.Dialog;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class CloseButtonDialog
extends Dialog {
    @Autowired
    @Qualifier(value="clientEventBus")
    protected AsyncEventBus clientEventBus;
    @Autowired
    private ParentNodeProvider parentNodeProvider;
    private static final int CLOSE_BUTTON_HEIGHT = 24;
    private static final int CLOSE_BUTTON_WIDTH = 62;
    private static final int CLOSE_BUTTON_PADDING = 40;
    public static final int CLOSE_BTN_Y_POS = 627;
    private StringProperty title = new SimpleStringProperty((Object)this, "title", "");
    private StringProperty closeLabel = new SimpleStringProperty((Object)this, "closeLabel", "");
    private final OpenPatricianSmallWaxButton closeButton;

    public CloseButtonDialog(Font font) {
        super(font);
        Label titleLbl = new Label();
        titleLbl.getStyleClass().add((Object)"dialogTitle");
        titleLbl.textProperty().bind((ObservableValue)this.title);
        titleLbl.setFont(font);
        StackPane titlePane = new StackPane();
        titlePane.setLayoutY(30.0);
        titlePane.getChildren().addAll((Object[])new Node[]{new PlaceHolder(518.0, 1.0), titleLbl});
        this.getContent().add((Object)titlePane);
        this.closeButton = new OpenPatricianSmallWaxButton("X", font);
        this.closeButton.setLayoutX(416.0);
        this.closeButton.setLayoutY(627.0);
        this.closeButton.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CloseButtonDialog.this.executeOnCloseButtonClicked();
            }
        });
        this.closeButton.getStyleClass().add((Object)"buttonLabel");
        this.getContent().add((Object)this.closeButton);
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    protected OpenPatricianSmallWaxButton getCloseButton() {
        return null;
    }

    public void removeDecoratedContent() {
        ArrayList<DecoratedText> removables = new ArrayList<DecoratedText>();
        for (Node child : this.getContent()) {
            if (!(child instanceof DecoratedText)) continue;
            removables.add((DecoratedText)child);
        }
        Platform.runLater(() -> this.getContent().removeAll((Collection)removables));
    }

    public StringProperty closeLabelProperty() {
        return this.closeLabel;
    }

    public String getCloseLabel() {
        return (String)this.closeLabel.get();
    }

    public void setCloseLabel(String closeLabel) {
        this.closeLabel.set((Object)closeLabel);
    }

    public void addButtomControlButtons(OpenPatricianSmallWaxButton ... buttons) {
        double availableSpace = 376.0;
        double widthButtonAndGap = availableSpace / (double)buttons.length;
        Preconditions.checkState((widthButtonAndGap >= 62.0 ? 1 : 0) != 0, (Object)"Cannot draw buttons as there is not enough space");
        double gap = widthButtonAndGap - 62.0;
        double x = 40.0;
        for (OpenPatricianSmallWaxButton btn : buttons) {
            btn.setLayoutX(x);
            btn.setLayoutY(627.0);
            x += 62.0 + gap;
            this.getContent().add((Object)btn);
        }
    }

    protected void executeOnCloseButtonClicked() {
        MainGameView mainGameView = (MainGameView)this.parentNodeProvider.getParent((Node)this);
        if (mainGameView != null) {
            mainGameView.closeDialog();
        }
    }
}

