/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.javafx.control.PaginationV2;
import ch.sahits.game.javafx.control.PaginationV2Builder;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.personal.EMilitantCareer;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.model.personal.IMilitantCareer;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.TextParser;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@UniquePrototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.SINGLETON_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class HistoryStandaloneDialog
extends CloseButtonDialog {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Font font;
    protected final ICityPlayerProxyJFX city;
    private final String historyResource;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    @Qualifier(value="resourceReference")
    private MessageSource resources;
    @Autowired
    private TextParser textParser;
    @Autowired
    private IFontLoader fontLoader;
    @Autowired
    private ModelTranslations modelTranslator;

    public HistoryStandaloneDialog(Font font, ICityPlayerProxyJFX city, String historyResource) {
        super(font);
        this.font = font;
        this.city = city;
        this.historyResource = historyResource;
    }

    @PostConstruct
    private void initializeDialog() {
        ch.sahits.game.openpatrician.util.model.Text historyText = this.getHistoryText();
        Insets insets = new Insets(15.0, 15.0, 15.0, 30.0);
        Font headerFont = this.fontLoader.createDefaultFont((int)this.font.getSize() + 6);
        PaginationV2 pagination = PaginationV2Builder.create().backButtonLabel(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.CreditsScene.back", new Object[0], this.locale.getCurrentLocal())).nextButtonLabel(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.CreditsScene.next", new Object[0], this.locale.getCurrentLocal())).text(historyText).contentMaxWidth(458.0).contentMaxHeight(567.0).padding(insets).navigationLabelFont(this.font).headerFont(headerFont).paragraphFont(this.font).centeredFont(this.font).firstLastPageAction(event -> {
            MainGameView mainGameView = (MainGameView)this.getParent();
            mainGameView.closeDialog();
        }).build();
        pagination.setLayoutY(30.0);
        this.getContent().add((Object)pagination);
    }

    private ch.sahits.game.openpatrician.util.model.Text getHistoryText() {
        String resourceName = this.resources.getMessage(this.historyResource, new Object[0], this.locale.getCurrentLocal());
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourceName);
        try {
            InputStream is = url.openStream();
            return this.textParser.parse(is);
        }
        catch (IOException e) {
            this.logger.warn("History text could not be found: " + url.toExternalForm());
            return new ch.sahits.game.openpatrician.util.model.Text();
        }
    }

    private void createAndAddNewText(VBox box, String s) {
        Text spouseName = new Text(s);
        spouseName.setFont(this.font);
        box.getChildren().add((Object)spouseName);
    }

    private Node createEmptyNode() {
        Text text = new Text("");
        text.setFont(this.font);
        return text;
    }

    private String getReputationText(IReputation reputation) {
        int repDiff = reputation.getReputationDifference();
        StringBuilder sb = new StringBuilder();
        if (repDiff < 0) {
            if (repDiff <= -10 && repDiff > -25) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.sunkenRep1", new Object[0], this.locale.getCurrentLocal()));
            } else if (repDiff > -10) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.sunkenRep2", new Object[0], this.locale.getCurrentLocal()));
            } else {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.sunkenRep3", new Object[0], this.locale.getCurrentLocal()));
            }
        } else if (repDiff > 0) {
            if (repDiff >= 10 && repDiff < 25) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.risenRep1", new Object[0], this.locale.getCurrentLocal()));
            } else if (repDiff < 10) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.risenRep2", new Object[0], this.locale.getCurrentLocal()));
            } else {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.risenRep3", new Object[0], this.locale.getCurrentLocal()));
            }
        } else {
            sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.unchangedRep", new Object[0], this.locale.getCurrentLocal()));
        }
        return sb.toString();
    }

    private List<String> getCareerAdvice(IPlayer player, IReputation reputation) {
        ESocialRank rank = player.getRank();
        ArrayList<String> lines = new ArrayList<String>();
        if (rank != ESocialRank.ALDERMAN && rank != ESocialRank.MAYOR) {
            ESocialRank nextRank = rank.getNextRank();
            boolean needFortune = false;
            if (player.getCompany().getCompanyValue() < (long)nextRank.getCompanyValue()) {
                needFortune = true;
            }
            boolean needReputation = false;
            if (reputation.getPopularity() < nextRank.getSocialReputation()) {
                needReputation = true;
            }
            StringBuilder sb = new StringBuilder();
            if (needFortune && needReputation) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice1_1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
                lines.add(sb.toString());
                sb = new StringBuilder();
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice1_2", new Object[0], this.locale.getCurrentLocal()));
                lines.add(sb.toString());
            } else if (needFortune) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice2_1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
                lines.add(sb.toString());
                sb = new StringBuilder();
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice1_2", new Object[0], this.locale.getCurrentLocal()));
                lines.add(sb.toString());
            } else if (needReputation) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice3_1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
                lines.add(sb.toString());
                sb = new StringBuilder();
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice1_2", new Object[0], this.locale.getCurrentLocal()));
                lines.add(sb.toString());
            }
        }
        return lines;
    }

    public List<String> getSpouseReputation(IPlayer player, ISpouseData spouse) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (this.city.getCity() == spouse.getBirthPlace()) {
            if (spouse.isMale()) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            } else {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep2", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            }
            lines.add(sb.toString());
            sb = new StringBuilder();
            lines.add(sb.toString());
            sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep3", new Object[0], this.locale.getCurrentLocal()));
        } else if (this.city.getCity() == player.getCompany().getHomeTown()) {
            if (spouse.isMale()) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            } else {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep2", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            }
            lines.add(sb.toString());
            sb = new StringBuilder();
            lines.add(sb.toString());
            sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep3", new Object[0], this.locale.getCurrentLocal()));
        } else {
            if (spouse.isMale()) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            } else {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep2", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            }
            lines.add(sb.toString());
            sb = new StringBuilder();
            lines.add(sb.toString());
            sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep3", new Object[0], this.locale.getCurrentLocal()));
        }
        return lines;
    }

    private String getUnderworldReputation(IPlayer player) {
        ICareer careerLevel = player.getCareerLevel();
        String s = careerLevel instanceof IMilitantCareer ? ((EMilitantCareer)careerLevel != EMilitantCareer.BOISTEROUS && (EMilitantCareer)careerLevel != EMilitantCareer.BOLD ? this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.underworldRep1", new Object[0], this.locale.getCurrentLocal()) : this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.underworldRep2", new Object[0], this.locale.getCurrentLocal())) : this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.underworldRep2", new Object[0], this.locale.getCurrentLocal());
        return s;
    }

    private String getPrefix(ISpouseData spouseData) {
        if (spouseData.isMale()) {
            return this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.malePrefix", new Object[0], this.locale.getCurrentLocal());
        }
        return this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.femalePrefix", new Object[0], this.locale.getCurrentLocal());
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }
}

