/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.dialog.BaseTradeDialog;
import ch.sahits.game.graphic.display.dialog.util.EDialogType;
import ch.sahits.game.javafx.control.BarrelIconView;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class StorageShipTradeDialog
extends BaseTradeDialog {
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public StorageShipTradeDialog(Font font, ICityPlayerProxyJFX city) {
        super(font, city, EDialogType.STORAGE_TO_SHIP);
    }

    @Override
    protected String getTradeToDestination() {
        return this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.ship", new Object[0], this.locale.getCurrentLocal());
    }

    @Override
    protected String getTradeFromDestination() {
        return this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.CityStorageTradeDialog.storage", new Object[0], this.locale.getCurrentLocal());
    }

    @Override
    protected Group createSubTitle(Font font, ICityPlayerProxyJFX city) {
        final IShip ship = city.getActiveShip();
        StringBinding shipLoad = new StringBinding(){
            {
                super.bind(new Observable[]{ship.getLoadBinding()});
            }

            protected String computeValue() {
                return ship.getLoadBinding().asString().get() + " / " + (ship.getSize() - ship.getUpgradeSpaceReduction()) + " " + ship.getName();
            }
        };
        Text cityText = new Text();
        cityText.textProperty().bind((ObservableValue)shipLoad);
        cityText.setFont(font);
        Group g = new Group();
        g.setManaged(false);
        final ITradingOffice office = city.getPlayer().findTradingOffice(city.getCity());
        BarrelIconView barrel = new BarrelIconView();
        barrel.setLayoutX(174.0);
        barrel.setLayoutY(-12.0);
        StringBinding storageLoad = new StringBinding(){
            {
                super.bind(new Observable[]{office.storedAmountBinding(), office.capacityProperty()});
            }

            protected String computeValue() {
                return office.storedAmountBinding().asString().get() + " / " + office.capacityProperty().get();
            }
        };
        Text shipSpace = new Text();
        shipSpace.textProperty().bind((ObservableValue)storageLoad);
        shipSpace.setFont(font);
        shipSpace.setLayoutX(200.0);
        Text shipName = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.CityStorageTradeDialog.storage", new Object[0], this.locale.getCurrentLocal()));
        shipName.setFont(font);
        shipName.setLayoutX(300.0);
        g.getChildren().addAll((Object[])new Node[]{cityText, barrel, shipSpace, shipName});
        return g;
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }
}

