/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.action;

import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.IWare;
import com.google.common.base.Preconditions;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.util.Pair;

@ClassCategory(value={EClassCategory.HANDLER})
class City2ShipJFXAction
implements Runnable {
    private final IWare ware;
    private final ITransferableJFX dialog;

    public City2ShipJFXAction(IWare ware, ITransferableJFX dialog) {
        this.ware = ware;
        this.dialog = dialog;
    }

    @Override
    public void run() {
        ICityPlayerProxyJFX city = this.dialog.getCityPlayerProxy();
        int availableAmountCity = city.getCity().getWare(this.ware).getAmount();
        if (availableAmountCity > 0) {
            int loaded;
            int amount2Move = this.dialog.getAmount(availableAmountCity);
            short sizeAsBarrels = this.ware.getSizeAsBarrels();
            ITradingOffice office = city.getPlayer().findTradingOffice(city.getCity());
            if (sizeAsBarrels == 1) {
                if (office == null) {
                    amount2Move = Math.min(amount2Move, city.getActiveShip().getCapacity());
                }
            } else {
                int temp = Math.min(amount2Move * sizeAsBarrels, city.getActiveShip().getCapacity());
                amount2Move = temp / sizeAsBarrels;
            }
            int avgPrice = this.ware.buyPrice((IntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amount2Move));
            long cash = city.getPlayer().getCompany().getCash();
            Pair<Integer, Integer> affordable = this.calculateAffordableAmount(cash, amount2Move, avgPrice, availableAmountCity);
            amount2Move = (Integer)affordable.getKey();
            avgPrice = (Integer)affordable.getValue();
            if (amount2Move <= 0) {
                return;
            }
            int movedAmount = city.getCity().move(this.ware, -amount2Move, (ICitizen)city.getPlayer());
            if (amount2Move != -movedAmount) {
                avgPrice = this.ware.buyPrice((IntegerProperty)new SimpleIntegerProperty(city.getCity().getWare(this.ware).getAmount() + movedAmount), (IntegerBinding)new ConstantIntegerBinding(movedAmount));
                amount2Move = -movedAmount;
            }
            if (office == null) {
                loaded = city.getActiveShip().load(this.ware, amount2Move, avgPrice);
            } else {
                int capacity = city.getActiveShip().getCapacity();
                if (amount2Move > capacity) {
                    int loadOntoShip = capacity;
                    int storeInOffice = amount2Move - capacity;
                    loaded = city.getActiveShip().load(this.ware, loadOntoShip, avgPrice);
                    loaded += office.move(this.ware, storeInOffice);
                } else {
                    loaded = city.getActiveShip().load(this.ware, amount2Move, avgPrice);
                }
            }
            city.getPlayer().updateCash(-avgPrice * loaded);
        }
    }

    Pair<Integer, Integer> calculateAffordableAmount(long cash, int desiredAmount, int avgPrice, int availableAmountCity) {
        if (cash < (long)avgPrice * (long)desiredAmount) {
            int amountAprox = (int)(cash / (long)avgPrice);
            if (amountAprox > 0) {
                int newTempPrice;
                int tempPrice = this.ware.buyPrice((IntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amountAprox));
                Preconditions.checkArgument(((long)(amountAprox * tempPrice) <= cash ? 1 : 0) != 0, (Object)"Buying fewer items never results in a higher avg price");
                while ((long)(amountAprox * tempPrice + tempPrice) < cash && (long)(++amountAprox * (newTempPrice = this.ware.buyPrice((IntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amountAprox)))) <= cash) {
                    tempPrice = newTempPrice;
                }
                return new Pair((Object)amountAprox, (Object)tempPrice);
            }
            return new Pair((Object)0, (Object)0);
        }
        return new Pair((Object)desiredAmount, (Object)avgPrice);
    }
}

